/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.CompressionFormat;
import com.amazonaws.services.gluedatabrew.model.OutputFormat;
import com.amazonaws.services.gluedatabrew.model.OutputFormatOptions;
import com.amazonaws.services.gluedatabrew.model.S3Location;
import com.amazonaws.services.gluedatabrew.model.transform.OutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Output
implements Serializable,
Cloneable,
StructuredPojo {
    private String compressionFormat;
    private String format;
    private List<String> partitionColumns;
    private S3Location location;
    private Boolean overwrite;
    private OutputFormatOptions formatOptions;

    public void setCompressionFormat(String compressionFormat) {
        this.compressionFormat = compressionFormat;
    }

    public String getCompressionFormat() {
        return this.compressionFormat;
    }

    public Output withCompressionFormat(String compressionFormat) {
        this.setCompressionFormat(compressionFormat);
        return this;
    }

    public Output withCompressionFormat(CompressionFormat compressionFormat) {
        this.compressionFormat = compressionFormat.toString();
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public Output withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public Output withFormat(OutputFormat format) {
        this.format = format.toString();
        return this;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public void setPartitionColumns(Collection<String> partitionColumns) {
        if (partitionColumns == null) {
            this.partitionColumns = null;
            return;
        }
        this.partitionColumns = new ArrayList<String>(partitionColumns);
    }

    public Output withPartitionColumns(String ... partitionColumns) {
        if (this.partitionColumns == null) {
            this.setPartitionColumns(new ArrayList<String>(partitionColumns.length));
        }
        for (String ele : partitionColumns) {
            this.partitionColumns.add(ele);
        }
        return this;
    }

    public Output withPartitionColumns(Collection<String> partitionColumns) {
        this.setPartitionColumns(partitionColumns);
        return this;
    }

    public void setLocation(S3Location location) {
        this.location = location;
    }

    public S3Location getLocation() {
        return this.location;
    }

    public Output withLocation(S3Location location) {
        this.setLocation(location);
        return this;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public Output withOverwrite(Boolean overwrite) {
        this.setOverwrite(overwrite);
        return this;
    }

    public Boolean isOverwrite() {
        return this.overwrite;
    }

    public void setFormatOptions(OutputFormatOptions formatOptions) {
        this.formatOptions = formatOptions;
    }

    public OutputFormatOptions getFormatOptions() {
        return this.formatOptions;
    }

    public Output withFormatOptions(OutputFormatOptions formatOptions) {
        this.setFormatOptions(formatOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCompressionFormat() != null) {
            sb.append("CompressionFormat: ").append(this.getCompressionFormat()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getPartitionColumns() != null) {
            sb.append("PartitionColumns: ").append(this.getPartitionColumns()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getOverwrite() != null) {
            sb.append("Overwrite: ").append(this.getOverwrite()).append(",");
        }
        if (this.getFormatOptions() != null) {
            sb.append("FormatOptions: ").append(this.getFormatOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        if (other.getCompressionFormat() == null ^ this.getCompressionFormat() == null) {
            return false;
        }
        if (other.getCompressionFormat() != null && !other.getCompressionFormat().equals(this.getCompressionFormat())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getPartitionColumns() == null ^ this.getPartitionColumns() == null) {
            return false;
        }
        if (other.getPartitionColumns() != null && !other.getPartitionColumns().equals(this.getPartitionColumns())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getOverwrite() == null ^ this.getOverwrite() == null) {
            return false;
        }
        if (other.getOverwrite() != null && !other.getOverwrite().equals(this.getOverwrite())) {
            return false;
        }
        if (other.getFormatOptions() == null ^ this.getFormatOptions() == null) {
            return false;
        }
        return other.getFormatOptions() == null || other.getFormatOptions().equals(this.getFormatOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCompressionFormat() == null ? 0 : this.getCompressionFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionColumns() == null ? 0 : this.getPartitionColumns().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getOverwrite() == null ? 0 : this.getOverwrite().hashCode());
        hashCode = 31 * hashCode + (this.getFormatOptions() == null ? 0 : this.getFormatOptions().hashCode());
        return hashCode;
    }

    public Output clone() {
        try {
            return (Output)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

