/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AllocationStrategy;
import com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy;
import com.amazonaws.services.ec2.model.FleetType;
import com.amazonaws.services.ec2.model.InstanceInterruptionBehavior;
import com.amazonaws.services.ec2.model.LaunchTemplateConfig;
import com.amazonaws.services.ec2.model.LoadBalancersConfig;
import com.amazonaws.services.ec2.model.OnDemandAllocationStrategy;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotMaintenanceStrategies;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TargetCapacityUnitType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SpotFleetRequestConfigData
implements Serializable,
Cloneable {
    private String allocationStrategy;
    private String onDemandAllocationStrategy;
    private SpotMaintenanceStrategies spotMaintenanceStrategies;
    private String clientToken;
    private String excessCapacityTerminationPolicy;
    private Double fulfilledCapacity;
    private Double onDemandFulfilledCapacity;
    private String iamFleetRole;
    private SdkInternalList<SpotFleetLaunchSpecification> launchSpecifications;
    private SdkInternalList<LaunchTemplateConfig> launchTemplateConfigs;
    private String spotPrice;
    private Integer targetCapacity;
    private Integer onDemandTargetCapacity;
    private String onDemandMaxTotalPrice;
    private String spotMaxTotalPrice;
    private Boolean terminateInstancesWithExpiration;
    private String type;
    private Date validFrom;
    private Date validUntil;
    private Boolean replaceUnhealthyInstances;
    private String instanceInterruptionBehavior;
    private LoadBalancersConfig loadBalancersConfig;
    private Integer instancePoolsToUseCount;
    private String context;
    private String targetCapacityUnitType;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public SpotFleetRequestConfigData withAllocationStrategy(String allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public void setAllocationStrategy(AllocationStrategy allocationStrategy) {
        this.withAllocationStrategy(allocationStrategy);
    }

    public SpotFleetRequestConfigData withAllocationStrategy(AllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
        return this;
    }

    public void setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
        this.onDemandAllocationStrategy = onDemandAllocationStrategy;
    }

    public String getOnDemandAllocationStrategy() {
        return this.onDemandAllocationStrategy;
    }

    public SpotFleetRequestConfigData withOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
        this.setOnDemandAllocationStrategy(onDemandAllocationStrategy);
        return this;
    }

    public void setOnDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy) {
        this.withOnDemandAllocationStrategy(onDemandAllocationStrategy);
    }

    public SpotFleetRequestConfigData withOnDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy) {
        this.onDemandAllocationStrategy = onDemandAllocationStrategy.toString();
        return this;
    }

    public void setSpotMaintenanceStrategies(SpotMaintenanceStrategies spotMaintenanceStrategies) {
        this.spotMaintenanceStrategies = spotMaintenanceStrategies;
    }

    public SpotMaintenanceStrategies getSpotMaintenanceStrategies() {
        return this.spotMaintenanceStrategies;
    }

    public SpotFleetRequestConfigData withSpotMaintenanceStrategies(SpotMaintenanceStrategies spotMaintenanceStrategies) {
        this.setSpotMaintenanceStrategies(spotMaintenanceStrategies);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public SpotFleetRequestConfigData withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
    }

    public String getExcessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public SpotFleetRequestConfigData withExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.setExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
        return this;
    }

    public void setExcessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.withExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
    }

    public SpotFleetRequestConfigData withExcessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
        return this;
    }

    public void setFulfilledCapacity(Double fulfilledCapacity) {
        this.fulfilledCapacity = fulfilledCapacity;
    }

    public Double getFulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public SpotFleetRequestConfigData withFulfilledCapacity(Double fulfilledCapacity) {
        this.setFulfilledCapacity(fulfilledCapacity);
        return this;
    }

    public void setOnDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
        this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
    }

    public Double getOnDemandFulfilledCapacity() {
        return this.onDemandFulfilledCapacity;
    }

    public SpotFleetRequestConfigData withOnDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
        this.setOnDemandFulfilledCapacity(onDemandFulfilledCapacity);
        return this;
    }

    public void setIamFleetRole(String iamFleetRole) {
        this.iamFleetRole = iamFleetRole;
    }

    public String getIamFleetRole() {
        return this.iamFleetRole;
    }

    public SpotFleetRequestConfigData withIamFleetRole(String iamFleetRole) {
        this.setIamFleetRole(iamFleetRole);
        return this;
    }

    public List<SpotFleetLaunchSpecification> getLaunchSpecifications() {
        if (this.launchSpecifications == null) {
            this.launchSpecifications = new SdkInternalList();
        }
        return this.launchSpecifications;
    }

    public void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        if (launchSpecifications == null) {
            this.launchSpecifications = null;
            return;
        }
        this.launchSpecifications = new SdkInternalList(launchSpecifications);
    }

    public SpotFleetRequestConfigData withLaunchSpecifications(SpotFleetLaunchSpecification ... launchSpecifications) {
        if (this.launchSpecifications == null) {
            this.setLaunchSpecifications((Collection<SpotFleetLaunchSpecification>)new SdkInternalList(launchSpecifications.length));
        }
        for (SpotFleetLaunchSpecification ele : launchSpecifications) {
            this.launchSpecifications.add((Object)ele);
        }
        return this;
    }

    public SpotFleetRequestConfigData withLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        this.setLaunchSpecifications(launchSpecifications);
        return this;
    }

    public List<LaunchTemplateConfig> getLaunchTemplateConfigs() {
        if (this.launchTemplateConfigs == null) {
            this.launchTemplateConfigs = new SdkInternalList();
        }
        return this.launchTemplateConfigs;
    }

    public void setLaunchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
        if (launchTemplateConfigs == null) {
            this.launchTemplateConfigs = null;
            return;
        }
        this.launchTemplateConfigs = new SdkInternalList(launchTemplateConfigs);
    }

    public SpotFleetRequestConfigData withLaunchTemplateConfigs(LaunchTemplateConfig ... launchTemplateConfigs) {
        if (this.launchTemplateConfigs == null) {
            this.setLaunchTemplateConfigs((Collection<LaunchTemplateConfig>)new SdkInternalList(launchTemplateConfigs.length));
        }
        for (LaunchTemplateConfig ele : launchTemplateConfigs) {
            this.launchTemplateConfigs.add((Object)ele);
        }
        return this;
    }

    public SpotFleetRequestConfigData withLaunchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
        this.setLaunchTemplateConfigs(launchTemplateConfigs);
        return this;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public SpotFleetRequestConfigData withSpotPrice(String spotPrice) {
        this.setSpotPrice(spotPrice);
        return this;
    }

    public void setTargetCapacity(Integer targetCapacity) {
        this.targetCapacity = targetCapacity;
    }

    public Integer getTargetCapacity() {
        return this.targetCapacity;
    }

    public SpotFleetRequestConfigData withTargetCapacity(Integer targetCapacity) {
        this.setTargetCapacity(targetCapacity);
        return this;
    }

    public void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
        this.onDemandTargetCapacity = onDemandTargetCapacity;
    }

    public Integer getOnDemandTargetCapacity() {
        return this.onDemandTargetCapacity;
    }

    public SpotFleetRequestConfigData withOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
        this.setOnDemandTargetCapacity(onDemandTargetCapacity);
        return this;
    }

    public void setOnDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
        this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
    }

    public String getOnDemandMaxTotalPrice() {
        return this.onDemandMaxTotalPrice;
    }

    public SpotFleetRequestConfigData withOnDemandMaxTotalPrice(String onDemandMaxTotalPrice) {
        this.setOnDemandMaxTotalPrice(onDemandMaxTotalPrice);
        return this;
    }

    public void setSpotMaxTotalPrice(String spotMaxTotalPrice) {
        this.spotMaxTotalPrice = spotMaxTotalPrice;
    }

    public String getSpotMaxTotalPrice() {
        return this.spotMaxTotalPrice;
    }

    public SpotFleetRequestConfigData withSpotMaxTotalPrice(String spotMaxTotalPrice) {
        this.setSpotMaxTotalPrice(spotMaxTotalPrice);
        return this;
    }

    public void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
    }

    public Boolean getTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public SpotFleetRequestConfigData withTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.setTerminateInstancesWithExpiration(terminateInstancesWithExpiration);
        return this;
    }

    public Boolean isTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public SpotFleetRequestConfigData withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(FleetType type) {
        this.withType(type);
    }

    public SpotFleetRequestConfigData withType(FleetType type) {
        this.type = type.toString();
        return this;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public SpotFleetRequestConfigData withValidFrom(Date validFrom) {
        this.setValidFrom(validFrom);
        return this;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public SpotFleetRequestConfigData withValidUntil(Date validUntil) {
        this.setValidUntil(validUntil);
        return this;
    }

    public void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
        this.replaceUnhealthyInstances = replaceUnhealthyInstances;
    }

    public Boolean getReplaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public SpotFleetRequestConfigData withReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
        this.setReplaceUnhealthyInstances(replaceUnhealthyInstances);
        return this;
    }

    public Boolean isReplaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
        this.instanceInterruptionBehavior = instanceInterruptionBehavior;
    }

    public String getInstanceInterruptionBehavior() {
        return this.instanceInterruptionBehavior;
    }

    public SpotFleetRequestConfigData withInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
        this.setInstanceInterruptionBehavior(instanceInterruptionBehavior);
        return this;
    }

    public void setInstanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
        this.withInstanceInterruptionBehavior(instanceInterruptionBehavior);
    }

    public SpotFleetRequestConfigData withInstanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
        this.instanceInterruptionBehavior = instanceInterruptionBehavior.toString();
        return this;
    }

    public void setLoadBalancersConfig(LoadBalancersConfig loadBalancersConfig) {
        this.loadBalancersConfig = loadBalancersConfig;
    }

    public LoadBalancersConfig getLoadBalancersConfig() {
        return this.loadBalancersConfig;
    }

    public SpotFleetRequestConfigData withLoadBalancersConfig(LoadBalancersConfig loadBalancersConfig) {
        this.setLoadBalancersConfig(loadBalancersConfig);
        return this;
    }

    public void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
        this.instancePoolsToUseCount = instancePoolsToUseCount;
    }

    public Integer getInstancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public SpotFleetRequestConfigData withInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
        this.setInstancePoolsToUseCount(instancePoolsToUseCount);
        return this;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public SpotFleetRequestConfigData withContext(String context) {
        this.setContext(context);
        return this;
    }

    public void setTargetCapacityUnitType(String targetCapacityUnitType) {
        this.targetCapacityUnitType = targetCapacityUnitType;
    }

    public String getTargetCapacityUnitType() {
        return this.targetCapacityUnitType;
    }

    public SpotFleetRequestConfigData withTargetCapacityUnitType(String targetCapacityUnitType) {
        this.setTargetCapacityUnitType(targetCapacityUnitType);
        return this;
    }

    public void setTargetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
        this.withTargetCapacityUnitType(targetCapacityUnitType);
    }

    public SpotFleetRequestConfigData withTargetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
        this.targetCapacityUnitType = targetCapacityUnitType.toString();
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public SpotFleetRequestConfigData withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public SpotFleetRequestConfigData withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.getAllocationStrategy()).append(",");
        }
        if (this.getOnDemandAllocationStrategy() != null) {
            sb.append("OnDemandAllocationStrategy: ").append(this.getOnDemandAllocationStrategy()).append(",");
        }
        if (this.getSpotMaintenanceStrategies() != null) {
            sb.append("SpotMaintenanceStrategies: ").append(this.getSpotMaintenanceStrategies()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getExcessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.getExcessCapacityTerminationPolicy()).append(",");
        }
        if (this.getFulfilledCapacity() != null) {
            sb.append("FulfilledCapacity: ").append(this.getFulfilledCapacity()).append(",");
        }
        if (this.getOnDemandFulfilledCapacity() != null) {
            sb.append("OnDemandFulfilledCapacity: ").append(this.getOnDemandFulfilledCapacity()).append(",");
        }
        if (this.getIamFleetRole() != null) {
            sb.append("IamFleetRole: ").append(this.getIamFleetRole()).append(",");
        }
        if (this.getLaunchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.getLaunchSpecifications()).append(",");
        }
        if (this.getLaunchTemplateConfigs() != null) {
            sb.append("LaunchTemplateConfigs: ").append(this.getLaunchTemplateConfigs()).append(",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: ").append(this.getSpotPrice()).append(",");
        }
        if (this.getTargetCapacity() != null) {
            sb.append("TargetCapacity: ").append(this.getTargetCapacity()).append(",");
        }
        if (this.getOnDemandTargetCapacity() != null) {
            sb.append("OnDemandTargetCapacity: ").append(this.getOnDemandTargetCapacity()).append(",");
        }
        if (this.getOnDemandMaxTotalPrice() != null) {
            sb.append("OnDemandMaxTotalPrice: ").append(this.getOnDemandMaxTotalPrice()).append(",");
        }
        if (this.getSpotMaxTotalPrice() != null) {
            sb.append("SpotMaxTotalPrice: ").append(this.getSpotMaxTotalPrice()).append(",");
        }
        if (this.getTerminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(this.getTerminateInstancesWithExpiration()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: ").append(this.getValidFrom()).append(",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: ").append(this.getValidUntil()).append(",");
        }
        if (this.getReplaceUnhealthyInstances() != null) {
            sb.append("ReplaceUnhealthyInstances: ").append(this.getReplaceUnhealthyInstances()).append(",");
        }
        if (this.getInstanceInterruptionBehavior() != null) {
            sb.append("InstanceInterruptionBehavior: ").append(this.getInstanceInterruptionBehavior()).append(",");
        }
        if (this.getLoadBalancersConfig() != null) {
            sb.append("LoadBalancersConfig: ").append(this.getLoadBalancersConfig()).append(",");
        }
        if (this.getInstancePoolsToUseCount() != null) {
            sb.append("InstancePoolsToUseCount: ").append(this.getInstancePoolsToUseCount()).append(",");
        }
        if (this.getContext() != null) {
            sb.append("Context: ").append(this.getContext()).append(",");
        }
        if (this.getTargetCapacityUnitType() != null) {
            sb.append("TargetCapacityUnitType: ").append(this.getTargetCapacityUnitType()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData)obj;
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        if (other.getAllocationStrategy() != null && !other.getAllocationStrategy().equals(this.getAllocationStrategy())) {
            return false;
        }
        if (other.getOnDemandAllocationStrategy() == null ^ this.getOnDemandAllocationStrategy() == null) {
            return false;
        }
        if (other.getOnDemandAllocationStrategy() != null && !other.getOnDemandAllocationStrategy().equals(this.getOnDemandAllocationStrategy())) {
            return false;
        }
        if (other.getSpotMaintenanceStrategies() == null ^ this.getSpotMaintenanceStrategies() == null) {
            return false;
        }
        if (other.getSpotMaintenanceStrategies() != null && !other.getSpotMaintenanceStrategies().equals(this.getSpotMaintenanceStrategies())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() == null ^ this.getExcessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() != null && !other.getExcessCapacityTerminationPolicy().equals(this.getExcessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.getFulfilledCapacity() == null ^ this.getFulfilledCapacity() == null) {
            return false;
        }
        if (other.getFulfilledCapacity() != null && !other.getFulfilledCapacity().equals(this.getFulfilledCapacity())) {
            return false;
        }
        if (other.getOnDemandFulfilledCapacity() == null ^ this.getOnDemandFulfilledCapacity() == null) {
            return false;
        }
        if (other.getOnDemandFulfilledCapacity() != null && !other.getOnDemandFulfilledCapacity().equals(this.getOnDemandFulfilledCapacity())) {
            return false;
        }
        if (other.getIamFleetRole() == null ^ this.getIamFleetRole() == null) {
            return false;
        }
        if (other.getIamFleetRole() != null && !other.getIamFleetRole().equals(this.getIamFleetRole())) {
            return false;
        }
        if (other.getLaunchSpecifications() == null ^ this.getLaunchSpecifications() == null) {
            return false;
        }
        if (other.getLaunchSpecifications() != null && !other.getLaunchSpecifications().equals(this.getLaunchSpecifications())) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() == null ^ this.getLaunchTemplateConfigs() == null) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() != null && !other.getLaunchTemplateConfigs().equals(this.getLaunchTemplateConfigs())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getTargetCapacity() == null ^ this.getTargetCapacity() == null) {
            return false;
        }
        if (other.getTargetCapacity() != null && !other.getTargetCapacity().equals(this.getTargetCapacity())) {
            return false;
        }
        if (other.getOnDemandTargetCapacity() == null ^ this.getOnDemandTargetCapacity() == null) {
            return false;
        }
        if (other.getOnDemandTargetCapacity() != null && !other.getOnDemandTargetCapacity().equals(this.getOnDemandTargetCapacity())) {
            return false;
        }
        if (other.getOnDemandMaxTotalPrice() == null ^ this.getOnDemandMaxTotalPrice() == null) {
            return false;
        }
        if (other.getOnDemandMaxTotalPrice() != null && !other.getOnDemandMaxTotalPrice().equals(this.getOnDemandMaxTotalPrice())) {
            return false;
        }
        if (other.getSpotMaxTotalPrice() == null ^ this.getSpotMaxTotalPrice() == null) {
            return false;
        }
        if (other.getSpotMaxTotalPrice() != null && !other.getSpotMaxTotalPrice().equals(this.getSpotMaxTotalPrice())) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() == null ^ this.getTerminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() != null && !other.getTerminateInstancesWithExpiration().equals(this.getTerminateInstancesWithExpiration())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.getReplaceUnhealthyInstances() == null ^ this.getReplaceUnhealthyInstances() == null) {
            return false;
        }
        if (other.getReplaceUnhealthyInstances() != null && !other.getReplaceUnhealthyInstances().equals(this.getReplaceUnhealthyInstances())) {
            return false;
        }
        if (other.getInstanceInterruptionBehavior() == null ^ this.getInstanceInterruptionBehavior() == null) {
            return false;
        }
        if (other.getInstanceInterruptionBehavior() != null && !other.getInstanceInterruptionBehavior().equals(this.getInstanceInterruptionBehavior())) {
            return false;
        }
        if (other.getLoadBalancersConfig() == null ^ this.getLoadBalancersConfig() == null) {
            return false;
        }
        if (other.getLoadBalancersConfig() != null && !other.getLoadBalancersConfig().equals(this.getLoadBalancersConfig())) {
            return false;
        }
        if (other.getInstancePoolsToUseCount() == null ^ this.getInstancePoolsToUseCount() == null) {
            return false;
        }
        if (other.getInstancePoolsToUseCount() != null && !other.getInstancePoolsToUseCount().equals(this.getInstancePoolsToUseCount())) {
            return false;
        }
        if (other.getContext() == null ^ this.getContext() == null) {
            return false;
        }
        if (other.getContext() != null && !other.getContext().equals(this.getContext())) {
            return false;
        }
        if (other.getTargetCapacityUnitType() == null ^ this.getTargetCapacityUnitType() == null) {
            return false;
        }
        if (other.getTargetCapacityUnitType() != null && !other.getTargetCapacityUnitType().equals(this.getTargetCapacityUnitType())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandAllocationStrategy() == null ? 0 : this.getOnDemandAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getSpotMaintenanceStrategies() == null ? 0 : this.getSpotMaintenanceStrategies().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getExcessCapacityTerminationPolicy() == null ? 0 : this.getExcessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getFulfilledCapacity() == null ? 0 : this.getFulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandFulfilledCapacity() == null ? 0 : this.getOnDemandFulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getIamFleetRole() == null ? 0 : this.getIamFleetRole().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecifications() == null ? 0 : this.getLaunchSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplateConfigs() == null ? 0 : this.getLaunchTemplateConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacity() == null ? 0 : this.getTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandTargetCapacity() == null ? 0 : this.getOnDemandTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandMaxTotalPrice() == null ? 0 : this.getOnDemandMaxTotalPrice().hashCode());
        hashCode = 31 * hashCode + (this.getSpotMaxTotalPrice() == null ? 0 : this.getSpotMaxTotalPrice().hashCode());
        hashCode = 31 * hashCode + (this.getTerminateInstancesWithExpiration() == null ? 0 : this.getTerminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.getReplaceUnhealthyInstances() == null ? 0 : this.getReplaceUnhealthyInstances().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInterruptionBehavior() == null ? 0 : this.getInstanceInterruptionBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancersConfig() == null ? 0 : this.getLoadBalancersConfig().hashCode());
        hashCode = 31 * hashCode + (this.getInstancePoolsToUseCount() == null ? 0 : this.getInstancePoolsToUseCount().hashCode());
        hashCode = 31 * hashCode + (this.getContext() == null ? 0 : this.getContext().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacityUnitType() == null ? 0 : this.getTargetCapacityUnitType().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public SpotFleetRequestConfigData clone() {
        try {
            return (SpotFleetRequestConfigData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

