/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal.signer;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.RequestPresigner;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.internal.signer.OSSSignerParams;
import com.aliyun.oss.internal.signer.OSSV1Signer;
import com.aliyun.oss.internal.signer.OSSV2Signer;
import com.aliyun.oss.internal.signer.OSSV4Signer;
import java.util.Date;

public abstract class OSSSignerBase
implements RequestSigner,
RequestPresigner {
    protected final OSSSignerParams signerParams;

    protected OSSSignerBase(OSSSignerParams signerParams) {
        this.signerParams = signerParams;
    }

    protected void addDateHeaderIfNeeded(RequestMessage request) {
        Date now = new Date();
        if (this.signerParams.getTickOffset() != 0L) {
            now.setTime(now.getTime() + this.signerParams.getTickOffset());
        }
        request.getHeaders().put("Date", DateUtil.formatRfc822Date(now));
    }

    protected void addSecurityTokenHeaderIfNeeded(RequestMessage request) {
        Credentials cred = this.signerParams.getCredentials();
        if (cred.useSecurityToken() && !request.isUseUrlSignature()) {
            request.addHeader("x-oss-security-token", cred.getSecurityToken());
        }
    }

    protected boolean isAnonymous() {
        Credentials cred = this.signerParams.getCredentials();
        return cred.getAccessKeyId().length() <= 0 || cred.getSecretAccessKey().length() <= 0;
    }

    protected void addAuthorizationHeader(RequestMessage request) {
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        this.addDateHeaderIfNeeded(request);
        if (this.isAnonymous()) {
            return;
        }
        this.addSecurityTokenHeaderIfNeeded(request);
        this.addAuthorizationHeader(request);
    }

    public static RequestSigner createRequestSigner(SignVersion version, OSSSignerParams signerParams) {
        if (SignVersion.V4.equals((Object)version)) {
            return new OSSV4Signer(signerParams);
        }
        if (SignVersion.V2.equals((Object)version)) {
            return new OSSV2Signer(signerParams);
        }
        return new OSSV1Signer(signerParams);
    }

    public static RequestPresigner createRequestPresigner(SignVersion version, OSSSignerParams signerParams) {
        if (SignVersion.V4.equals((Object)version)) {
            return new OSSV4Signer(signerParams);
        }
        if (SignVersion.V2.equals((Object)version)) {
            return new OSSV2Signer(signerParams);
        }
        return new OSSV1Signer(signerParams);
    }
}

