/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import java.sql.SQLType;

public enum OTSType implements SQLType
{
    BOOLEAN("BOOLEAN", 16, Boolean.class, false, 3L, ""),
    DOUBLE("DOUBLE", 8, Double.class, true, 22L, "[(M,D)] [UNSIGNED] [ZEROFILL]"),
    BIGINT("BIGINT", -5, Long.class, true, 19L, "[(M)] [UNSIGNED] [ZEROFILL]"),
    VARCHAR("VARCHAR", 12, String.class, false, 1024L, "(M) [CHARACTER SET charset_name] [COLLATE collation_name]"),
    VARBINARY("VARBINARY", -3, null, false, 1024L, "(M)"),
    MEDIUMBLOB("MEDIUMBLOB", -4, null, false, 0x200000L, ""),
    MEDIUMTEXT("MEDIUMTEXT", -1, String.class, false, 0x200000L, " [CHARACTER SET charset_name] [COLLATE collation_name]"),
    UNKNOWN("UNKNOWN", 1111, null, false, 65535L, "");

    private final Class<?> javaClass;
    private final String name;
    private final boolean isDecimal;
    private final String createParams;
    private final int jdbcType;
    private long precision;

    private OTSType(String mysqlTypeName, int jdbcType, Class<?> javaClass, boolean isDec, long precision, String createParams) {
        this.name = mysqlTypeName;
        this.jdbcType = jdbcType;
        this.javaClass = javaClass;
        this.isDecimal = isDec;
        this.precision = precision;
        this.createParams = createParams;
    }

    public static OTSType getByName(String fullMysqlTypeName) {
        String typeName = "";
        long precision = 0L;
        if (fullMysqlTypeName.contains("(")) {
            int paramBeginIndex = fullMysqlTypeName.indexOf("(");
            int paramEndIndex = fullMysqlTypeName.indexOf(")");
            typeName = fullMysqlTypeName.substring(0, paramBeginIndex).trim();
            precision = Integer.parseInt(fullMysqlTypeName.substring(paramBeginIndex + 1, paramEndIndex));
        } else {
            typeName = fullMysqlTypeName;
        }
        OTSType type = UNKNOWN;
        String typeNameUpperCase = typeName.toUpperCase();
        if (typeNameUpperCase.equals("BIGINT")) {
            type = BIGINT;
        } else if (typeNameUpperCase.equals("DOUBLE")) {
            type = DOUBLE;
        } else if (typeNameUpperCase.equals("VARBINARY")) {
            type = VARBINARY;
        } else if (typeNameUpperCase.equals("VARCHAR")) {
            type = VARCHAR;
        } else if (typeNameUpperCase.equals("MEDIUMBLOB")) {
            type = MEDIUMBLOB;
        } else if (typeNameUpperCase.equals("MEDIUMTEXT")) {
            type = MEDIUMTEXT;
        } else if (typeNameUpperCase.equals("TINYINT")) {
            type = BOOLEAN;
        }
        if (precision > 0L) {
            type.precision = precision;
        }
        return type;
    }

    public static SQLType getByJdbcType(int jdbcType) {
        switch (jdbcType) {
            case 12: {
                return VARCHAR;
            }
            case -5: {
                return BIGINT;
            }
            case -3: {
                return VARBINARY;
            }
            case 8: {
                return DOUBLE;
            }
            case 16: {
                return BOOLEAN;
            }
        }
        return UNKNOWN;
    }

    public static boolean isSigned(OTSType type) {
        switch (type) {
            case BIGINT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLiteralL(OTSType type) {
        switch (type) {
            case VARBINARY: 
            case VARCHAR: 
            case MEDIUMBLOB: 
            case MEDIUMTEXT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getClassName() {
        return this.javaClass == null ? "[B" : this.javaClass.getName();
    }

    public boolean isDecimal() {
        return this.isDecimal;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getCreateParams() {
        return this.createParams;
    }

    @Override
    public String getVendor() {
        return "com.alicloud.openservices.tablestore.jdbc";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.jdbcType;
    }
}

