/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.jdbc.OTSConnection;
import com.alicloud.openservices.tablestore.jdbc.OTSResultSet;
import com.alicloud.openservices.tablestore.jdbc.WrapperAdapter;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryRequest;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryResponse;
import com.alicloud.openservices.tablestore.model.sql.SQLStatementType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class OTSStatement
extends WrapperAdapter
implements Statement {
    private final OTSConnection connection;
    private int maxFieldSize = 0;
    protected int resultSetMaxRows = 0;
    private OTSResultSet resultSet;
    private boolean isClosed = false;
    private SQLWarning warning = null;

    OTSStatement(OTSConnection conn) {
        this.connection = conn;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() {
        this.warning = null;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        SQLQueryRequest request = new SQLQueryRequest(sql);
        SQLQueryResponse response = this.connection.otsClient.sqlQuery(request);
        if (response.getSQLStatementType() == SQLStatementType.SQL_SELECT || response.getSQLStatementType() == SQLStatementType.SQL_SHOW_TABLE || response.getSQLStatementType() == SQLStatementType.SQL_DESCRIBE_TABLE) {
            this.resultSet = new OTSResultSet(this, response.getSQLResultSet(), this.resultSetMaxRows);
            return true;
        }
        this.resultSet = null;
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OTSConnection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.resultSetMaxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.resultSetMaxRows = max;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() {
        return this.connection.config.getClientConfiguration().getConnectionRequestTimeoutInMillisecond() / 1000;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        this.connection.setNetworkTimeout(null, seconds * 1000);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        if (this.resultSet == null) {
            return 0;
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the statement has been closed");
        }
    }
}

