/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.jdbc.WrapperAdapter;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.sql.SQLColumnSchema;
import com.alicloud.openservices.tablestore.model.sql.SQLTableMeta;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OTSResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final List<String> columnNames;
    private final List<ColumnType> columnTypes;

    OTSResultSetMetaData(SQLTableMeta meta) {
        this.columnNames = new ArrayList<String>();
        this.columnTypes = new ArrayList<ColumnType>();
        List columns = meta.getSchema();
        for (SQLColumnSchema column : columns) {
            this.columnNames.add(column.getName());
            this.columnTypes.add(column.getType());
        }
    }

    OTSResultSetMetaData(List<String> columnNames, List<ColumnType> columnTypes) {
        assert (columnNames.size() == columnTypes.size());
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
    }

    private int toZeroIndex(int column) throws SQLException {
        assert (this.columnNames.size() == this.columnTypes.size());
        if (column < 1 || column > this.columnNames.size()) {
            throw new SQLException("column index out of range");
        }
        return column - 1;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnType type = this.columnTypes.get(this.toZeroIndex(column));
        switch (type) {
            case BOOLEAN: {
                return Boolean.TYPE.getName();
            }
            case INTEGER: {
                return Long.TYPE.getName();
            }
            case DOUBLE: {
                return Double.TYPE.getName();
            }
            case STRING: {
                return String.class.getName();
            }
            case BINARY: {
                return byte[].class.getName();
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        ColumnType type = this.columnTypes.get(this.toZeroIndex(column));
        switch (type) {
            case BOOLEAN: {
                return 5;
            }
            case INTEGER: {
                return 20;
            }
            case DOUBLE: {
                return 24;
            }
            case STRING: {
                return 0x200000;
            }
            case BINARY: {
                return 0x200000;
            }
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnType type = this.columnTypes.get(this.toZeroIndex(column));
        switch (type) {
            case BOOLEAN: {
                return 16;
            }
            case INTEGER: {
                return -5;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case BINARY: {
                return -3;
            }
        }
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnType type = this.columnTypes.get(this.toZeroIndex(column));
        switch (type) {
            case BOOLEAN: {
                return "BOOL";
            }
            case INTEGER: {
                return "BIGINT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case STRING: {
                return "VARCHAR";
            }
            case BINARY: {
                return "VARBINARY";
            }
        }
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        ColumnType columnType = this.columnTypes.get(this.toZeroIndex(column));
        return columnType == ColumnType.DOUBLE || columnType == ColumnType.INTEGER;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }
}

