/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Properties;

class OTSConnectionConfiguration {
    private String endPoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String instanceName;
    private ClientConfiguration clientConfiguration;

    OTSConnectionConfiguration() {
    }

    static OTSConnectionConfiguration parse(String url, Properties info) throws SQLException {
        String query;
        String path;
        URL parsed;
        assert (url != null);
        assert (info != null);
        assert (url.startsWith("jdbc:ots:"));
        try {
            parsed = new URL(url.substring("jdbc:ots:".length()));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
        OTSConnectionConfiguration configuration = new OTSConnectionConfiguration();
        configuration.endPoint = parsed.getProtocol() + "://" + parsed.getHost();
        String userInfo = parsed.getUserInfo();
        if (userInfo != null) {
            String[] userPass = userInfo.split(":");
            configuration.accessKeyId = userPass[0];
            if (userPass.length >= 2) {
                configuration.accessKeySecret = userPass[1];
            }
        }
        if ((path = parsed.getPath()) != null && !path.isEmpty()) {
            configuration.instanceName = path.substring(1);
        }
        if ((query = parsed.getQuery()) != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] keyValue = param.split("=");
                if (keyValue.length != 2) continue;
                info.setProperty(keyValue[0], keyValue[1]);
            }
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        configuration.accessKeyId = info.getProperty("user", configuration.accessKeyId);
        configuration.accessKeySecret = info.getProperty("password", configuration.accessKeySecret);
        clientConfiguration.setEnableRequestCompression(Boolean.parseBoolean(info.getProperty("enableRequestCompression", String.valueOf(clientConfiguration.isEnableRequestCompression()))));
        clientConfiguration.setEnableResponseCompression(Boolean.parseBoolean(info.getProperty("enableResponseCompression", String.valueOf(clientConfiguration.isEnableResponseCompression()))));
        clientConfiguration.setEnableResponseValidation(Boolean.parseBoolean(info.getProperty("enableResponseValidation", String.valueOf(clientConfiguration.isEnableResponseValidation()))));
        clientConfiguration.setIoThreadCount(Integer.parseInt(info.getProperty("ioThreadCount", String.valueOf(clientConfiguration.getIoThreadCount()))));
        clientConfiguration.setMaxConnections(Integer.parseInt(info.getProperty("maxConnections", String.valueOf(clientConfiguration.getMaxConnections()))));
        clientConfiguration.setSocketTimeoutInMillisecond(Integer.parseInt(info.getProperty("socketTimeoutInMillisecond", String.valueOf(clientConfiguration.getSocketTimeoutInMillisecond()))));
        clientConfiguration.setConnectionTimeoutInMillisecond(Integer.parseInt(info.getProperty("connectionTimeoutInMillisecond", String.valueOf(clientConfiguration.getConnectionTimeoutInMillisecond()))));
        clientConfiguration.setRetryThreadCount(Integer.parseInt(info.getProperty("retryThreadCount", String.valueOf(clientConfiguration.getRetryThreadCount()))));
        clientConfiguration.setEnableResponseContentMD5Checking(Boolean.parseBoolean(info.getProperty("enableResponseContentMD5Checking", String.valueOf(clientConfiguration.isEnableResponseContentMD5Checking()))));
        clientConfiguration.setTimeThresholdOfTraceLogger(Integer.parseInt(info.getProperty("timeThresholdOfTraceLogger", String.valueOf(clientConfiguration.getTimeThresholdOfTraceLogger()))));
        clientConfiguration.setTimeThresholdOfServerTracer(Integer.parseInt(info.getProperty("timeThresholdOfServerTracer", String.valueOf(clientConfiguration.getTimeThresholdOfServerTracer()))));
        clientConfiguration.setProxyHost(info.getProperty("proxyHost"));
        clientConfiguration.setProxyPort(Integer.parseInt(info.getProperty("proxyPort", String.valueOf(clientConfiguration.getProxyPort()))));
        clientConfiguration.setProxyUsername(info.getProperty("proxyUsername"));
        clientConfiguration.setProxyPassword(info.getProperty("proxyPassword"));
        clientConfiguration.setProxyDomain(info.getProperty("proxyDomain"));
        clientConfiguration.setProxyWorkstation(info.getProperty("proxyWorkstation"));
        clientConfiguration.setSyncClientWaitFutureTimeoutInMillis(Long.parseLong(info.getProperty("syncClientWaitFutureTimeoutInMillis", String.valueOf(clientConfiguration.getSyncClientWaitFutureTimeoutInMillis()))));
        clientConfiguration.setConnectionRequestTimeoutInMillisecond(Integer.parseInt(info.getProperty("connectionRequestTimeoutInMillisecond", String.valueOf(clientConfiguration.getConnectionRequestTimeoutInMillisecond()))));
        configuration.clientConfiguration = clientConfiguration;
        return configuration;
    }

    ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    String getAccessKeyId() {
        return this.accessKeyId;
    }

    String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    String getEndPoint() {
        return this.endPoint;
    }

    String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }
}

