/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.comm;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.PartialResultFailedException;
import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSRetryStrategy;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.log.LogUtil;
import com.aliyun.openservices.ots.model.OTSBasicFuture;
import com.aliyun.openservices.ots.model.OTSResult;
import java.util.concurrent.TimeUnit;
import org.apache.http.concurrent.FutureCallback;

public class AsyncClientFutureCallback<Res>
implements FutureCallback<Res> {
    private OTSExecutionContext<?, Res> executionContext;
    private String action;

    public AsyncClientFutureCallback(String action, OTSExecutionContext<?, Res> executionContext) {
        this.action = action;
        this.executionContext = executionContext;
    }

    public void completed(Res result) {
        OTSBasicFuture<Res> future = this.executionContext.getFuture();
        OTSTraceLogger traceLogger = this.executionContext.getTraceLogger();
        if (result instanceof OTSResult) {
            ((OTSResult)result).setTraceId(traceLogger.getTraceId());
            LogUtil.logOnCompleted(this.executionContext, ((OTSResult)result).getRequestID());
            traceLogger.printLog();
            future.completed(result);
        } else {
            future.failed(new ClientException("Type error: The type of result is not OTSResult."));
        }
    }

    public void failed(Exception ex) {
        Exception e;
        final OTSBasicFuture<Res> future = this.executionContext.getFuture();
        OTSTraceLogger traceLogger = this.executionContext.getTraceLogger();
        OTSRetryStrategy retryStrategy = this.executionContext.getRetryStrategy();
        String requestId = null;
        if (ex instanceof OTSException) {
            e = ex;
            requestId = ((OTSException)ex).getRequestId();
            ((OTSException)e).setTraceId(traceLogger.getTraceId());
        } else if (ex instanceof ClientException) {
            e = ex;
            ((ClientException)e).setTraceId(traceLogger.getTraceId());
        } else {
            e = new ClientException("Unexpected error: " + ex, ex, traceLogger.getTraceId());
        }
        LogUtil.logOnFailed(this.executionContext, e, requestId);
        if (retryStrategy.shouldRetry(this.action, e, this.executionContext.getRetries() + 1)) {
            this.executionContext.getRetryExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncClientFutureCallback.this.executionContext.retry(e);
                        AsyncClientFutureCallback.this.executionContext.getCallable().call();
                    }
                    catch (Exception ex) {
                        future.failed(new ClientException("Failed to retry.", ex));
                    }
                }
            }, retryStrategy.getPauseDelay(this.action, e, this.executionContext.getRetries() + 1), TimeUnit.MILLISECONDS);
        } else if (e instanceof PartialResultFailedException) {
            traceLogger.printLog();
            future.completed(((PartialResultFailedException)e).getResult());
        } else {
            traceLogger.printLog();
            future.failed(e);
        }
    }

    public void cancelled() {
    }
}

