/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.common.ThreadLocalIndex;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.QueueData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.aliyun.openservices.shade.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TopicPublishInfo {
    private boolean orderTopic = false;
    private boolean haveTopicRouterInfo = false;
    private List<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private ConcurrentMap<Integer, ThreadLocalIndex> sendQueueMap = new ConcurrentHashMap<Integer, ThreadLocalIndex>();
    private TopicRouteData topicRouteData;
    private Map<Integer, List<MessageQueue>> queueListMap = new HashMap<Integer, List<MessageQueue>>();
    private boolean mainQueuePreferred = false;

    public boolean isMainQueuePreferred() {
        return this.mainQueuePreferred;
    }

    public void setMainQueuePreferred(boolean mainQueuePreferred) {
        this.mainQueuePreferred = mainQueuePreferred;
    }

    public boolean isOrderTopic() {
        return this.orderTopic;
    }

    public void setOrderTopic(boolean orderTopic) {
        this.orderTopic = orderTopic;
    }

    public boolean ok() {
        return null != this.messageQueueList && !this.messageQueueList.isEmpty();
    }

    public List<MessageQueue> getMessageQueueList() {
        return this.messageQueueList;
    }

    public void setMessageQueueList(List<MessageQueue> messageQueueList) {
        this.messageQueueList = messageQueueList;
    }

    public ThreadLocalIndex getSendWhichQueue() {
        return this.sendWhichQueue;
    }

    public void setSendWhichQueue(ThreadLocalIndex sendWhichQueue) {
        this.sendWhichQueue = sendWhichQueue;
    }

    public boolean isHaveTopicRouterInfo() {
        return this.haveTopicRouterInfo;
    }

    public void setHaveTopicRouterInfo(boolean haveTopicRouterInfo) {
        this.haveTopicRouterInfo = haveTopicRouterInfo;
    }

    public MessageQueue selectOneMessageQueue(QueueFilter ... filter) {
        return this.selectOneMessageQueue(this.messageQueueList, this.sendWhichQueue, filter);
    }

    public MessageQueue selectOneMessageQueue(int queueGroupId, QueueFilter ... filter) {
        if (!this.sendQueueMap.containsKey(queueGroupId)) {
            this.sendQueueMap.putIfAbsent(queueGroupId, new ThreadLocalIndex());
        }
        return this.selectOneMessageQueue(this.queueListMap.get(queueGroupId), (ThreadLocalIndex)this.sendQueueMap.get(queueGroupId), filter);
    }

    private MessageQueue selectOneMessageQueue(List<MessageQueue> messageQueueList, ThreadLocalIndex sendQueue, QueueFilter ... filter) {
        if (messageQueueList == null || messageQueueList.isEmpty()) {
            return null;
        }
        if (filter != null && filter.length != 0) {
            for (int i = 0; i < messageQueueList.size(); ++i) {
                int index = Math.abs(sendQueue.getAndIncrement() % messageQueueList.size());
                MessageQueue mq = messageQueueList.get(index);
                boolean filterResult = true;
                for (QueueFilter f : filter) {
                    Preconditions.checkNotNull(f);
                    filterResult &= f.filter(mq);
                }
                if (!filterResult) continue;
                return mq;
            }
            return null;
        }
        int index = Math.abs(sendQueue.getAndIncrement() % messageQueueList.size());
        return messageQueueList.get(index);
    }

    public void resetIndex() {
        this.sendWhichQueue.reset();
    }

    public int getQueueIdByBroker(String brokerName) {
        for (int i = 0; i < this.topicRouteData.getQueueDatas().size(); ++i) {
            QueueData queueData = this.topicRouteData.getQueueDatas().get(i);
            if (!queueData.getBrokerName().equals(brokerName)) continue;
            return queueData.getWriteQueueNums();
        }
        return -1;
    }

    public boolean isHAOrderTopic() {
        if (this.topicRouteData == null) {
            return false;
        }
        return this.topicRouteData.isHAOrderTopic();
    }

    public String toString() {
        return "TopicPublishInfo [orderTopic=" + this.orderTopic + ", messageQueueList=" + this.messageQueueList + ", sendWhichQueue=" + this.sendWhichQueue + ", haveTopicRouterInfo=" + this.haveTopicRouterInfo + "]";
    }

    public TopicRouteData getTopicRouteData() {
        return this.topicRouteData;
    }

    public void setTopicRouteData(TopicRouteData topicRouteData) {
        this.topicRouteData = topicRouteData;
    }

    public Map<Integer, List<MessageQueue>> getQueueListMap() {
        return this.queueListMap;
    }

    public void setQueueListMap(Map<Integer, List<MessageQueue>> queueListMap) {
        this.queueListMap = queueListMap;
    }

    public static interface QueueFilter {
        public boolean filter(MessageQueue var1);
    }
}

