/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.helper;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.QueueData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;

public class TopicSysFlagSetInnerHelper {
    private static final InternalLogger log = ClientLogger.getLog();

    public static void setTopicSysFlag(MessageExt messageExt, Integer topicSysFlagFromHeader, MQClientInstance mQClientFactory) {
        if (!messageExt.getTopic().startsWith("%RETRY%") && topicSysFlagFromHeader != null) {
            messageExt.setTopicSysFlag(topicSysFlagFromHeader);
        } else {
            String originTopic = !messageExt.getTopic().startsWith("%RETRY%") ? messageExt.getTopic() : messageExt.getProperty("RETRY_TOPIC");
            if (originTopic == null) {
                log.warn("[SetTopicSysFlag] NOT FOUND PROPERTY_RETRY_TOPIC for " + messageExt.getTopic() + " " + messageExt.getMsgId());
            } else {
                TopicRouteData topicRouteData = (TopicRouteData)mQClientFactory.getTopicRouteTable().get(originTopic);
                if (topicRouteData == null) {
                    log.warn("[SetTopicSysFlag]NOT FOUND topicRouteData for " + originTopic + " " + messageExt.getMsgId());
                } else if (topicRouteData.getQueueDatas().size() == 0) {
                    log.warn("[SetTopicSysFlag]NOT FOUND getQueueDatas for " + originTopic + " " + messageExt.getMsgId());
                } else {
                    QueueData queueData = topicRouteData.getQueueDatas().get(0);
                    if (queueData == null) {
                        log.warn("[SetTopicSysFlag] NULL QueueData for " + originTopic + " " + messageExt.getMsgId());
                    } else {
                        messageExt.setTopicSysFlag(queueData.getTopicSynFlag());
                    }
                }
            }
        }
    }
}

