package com.aliyun.httpcomponent.httpclient;

import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.HttpClientProvider;
import com.aliyun.core.utils.HttpClientOptions;

public class ApacheAsyncHttpClientProvider implements HttpClientProvider {

    @Override
    public HttpClient createInstance() {
        return new ApacheAsyncHttpClientBuilder().build();
    }
    @Override
    public HttpClient createInstance(HttpClientOptions clientOptions) {
        ApacheAsyncHttpClientBuilder builder = new ApacheAsyncHttpClientBuilder();
        if(clientOptions != null) {
            builder.proxy(clientOptions.getProxyOptions())
                    .configuration(clientOptions.getConfiguration())
                    .responseTimeout(clientOptions.getResponseTimeout());
        }
        return builder.build();
    }
}
