/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryTagsRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="ClientKey")
    @Validation(required=true)
    private String clientKey;
    @Query
    @NameInMap(value="KeyType")
    @Validation(required=true)
    private String keyType;

    private QueryTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.clientKey = builder.clientKey;
        this.keyType = builder.keyType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryTagsRequest create() {
        return QueryTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public static final class Builder
    extends Request.Builder<QueryTagsRequest, Builder> {
        private Long appKey;
        private String clientKey;
        private String keyType;

        private Builder() {
        }

        private Builder(QueryTagsRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.clientKey = request.clientKey;
            this.keyType = request.keyType;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder clientKey(String clientKey) {
            this.putQueryParameter("ClientKey", clientKey);
            this.clientKey = clientKey;
            return this;
        }

        public Builder keyType(String keyType) {
            this.putQueryParameter("KeyType", keyType);
            this.keyType = keyType;
            return this;
        }

        public QueryTagsRequest build() {
            return new QueryTagsRequest(this);
        }
    }
}

