/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class PushMessageToAndroidRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="Body")
    @Validation(required=true)
    private String body;
    @Query
    @NameInMap(value="JobKey")
    private String jobKey;
    @Query
    @NameInMap(value="StoreOffline")
    private Boolean storeOffline;
    @Query
    @NameInMap(value="Target")
    @Validation(required=true)
    private String target;
    @Query
    @NameInMap(value="TargetValue")
    @Validation(required=true)
    private String targetValue;
    @Query
    @NameInMap(value="Title")
    @Validation(required=true)
    private String title;

    private PushMessageToAndroidRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.body = builder.body;
        this.jobKey = builder.jobKey;
        this.storeOffline = builder.storeOffline;
        this.target = builder.target;
        this.targetValue = builder.targetValue;
        this.title = builder.title;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PushMessageToAndroidRequest create() {
        return PushMessageToAndroidRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getBody() {
        return this.body;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public Boolean getStoreOffline() {
        return this.storeOffline;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public String getTitle() {
        return this.title;
    }

    public static final class Builder
    extends Request.Builder<PushMessageToAndroidRequest, Builder> {
        private Long appKey;
        private String body;
        private String jobKey;
        private Boolean storeOffline;
        private String target;
        private String targetValue;
        private String title;

        private Builder() {
        }

        private Builder(PushMessageToAndroidRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.body = request.body;
            this.jobKey = request.jobKey;
            this.storeOffline = request.storeOffline;
            this.target = request.target;
            this.targetValue = request.targetValue;
            this.title = request.title;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder body(String body) {
            this.putQueryParameter("Body", body);
            this.body = body;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.putQueryParameter("JobKey", jobKey);
            this.jobKey = jobKey;
            return this;
        }

        public Builder storeOffline(Boolean storeOffline) {
            this.putQueryParameter("StoreOffline", storeOffline);
            this.storeOffline = storeOffline;
            return this;
        }

        public Builder target(String target) {
            this.putQueryParameter("Target", target);
            this.target = target;
            return this;
        }

        public Builder targetValue(String targetValue) {
            this.putQueryParameter("TargetValue", targetValue);
            this.targetValue = targetValue;
            return this;
        }

        public Builder title(String title) {
            this.putQueryParameter("Title", title);
            this.title = title;
            return this;
        }

        public PushMessageToAndroidRequest build() {
            return new PushMessageToAndroidRequest(this);
        }
    }
}

