/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.push20160801.models.PushTask;
import java.util.List;

public class MassPushV2Request
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="IdempotentToken")
    @Validation(maxLength=36, minLength=36)
    private String idempotentToken;
    @Query
    @NameInMap(value="PushTasks")
    @Validation(required=true)
    private List<PushTask> pushTasks;

    private MassPushV2Request(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.idempotentToken = builder.idempotentToken;
        this.pushTasks = builder.pushTasks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MassPushV2Request create() {
        return MassPushV2Request.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getIdempotentToken() {
        return this.idempotentToken;
    }

    public List<PushTask> getPushTasks() {
        return this.pushTasks;
    }

    public static final class Builder
    extends Request.Builder<MassPushV2Request, Builder> {
        private Long appKey;
        private String idempotentToken;
        private List<PushTask> pushTasks;

        private Builder() {
        }

        private Builder(MassPushV2Request request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.idempotentToken = request.idempotentToken;
            this.pushTasks = request.pushTasks;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder idempotentToken(String idempotentToken) {
            this.putQueryParameter("IdempotentToken", idempotentToken);
            this.idempotentToken = idempotentToken;
            return this;
        }

        public Builder pushTasks(List<PushTask> pushTasks) {
            String pushTasksShrink = this.shrink(pushTasks, "PushTasks", "json");
            this.putQueryParameter("PushTasks", pushTasksShrink);
            this.pushTasks = pushTasks;
            return this;
        }

        public MassPushV2Request build() {
            return new MassPushV2Request(this);
        }
    }
}

