/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.rest;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateDigestEncoder;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateDigestJsonEncoder;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateLogEnum;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateStatJsonReporter;
import com.sofa.alipay.tracer.plugins.rest.RestTemplateStatReporter;

public class RestTemplateTracer
extends AbstractClientTracer {
    protected RestTemplateTracer() {
        super("resttemplate");
    }

    protected String getClientDigestReporterLogName() {
        return RestTemplateLogEnum.REST_TEMPLATE_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return RestTemplateLogEnum.REST_TEMPLATE_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return RestTemplateLogEnum.REST_TEMPLATE_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new RestTemplateDigestJsonEncoder();
        }
        return new RestTemplateDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        RestTemplateLogEnum httpClientLogEnum = RestTemplateLogEnum.REST_TEMPLATE_STAT;
        String statLog = httpClientLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)httpClientLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)httpClientLogEnum.getLogNameKey());
        return this.getRestTemplateStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getRestTemplateStatReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new RestTemplateStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
        }
        return new RestTemplateStatReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

