/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.http;

import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.RpcConstants;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.server.http.AbstractHttpServerTask;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;

public class Http2ServerTask
extends AbstractHttpServerTask {
    protected final Integer streamId;
    protected final Http2ConnectionEncoder encoder;

    public Http2ServerTask(HttpServerHandler serverHandler, SofaRequest request, ChannelHandlerContext ctx, Integer streamId, Http2ConnectionEncoder encoder) {
        super(serverHandler, request, ctx);
        this.streamId = streamId;
        this.encoder = encoder;
    }

    @Override
    protected void sendAppResponse(HttpResponseStatus status, ByteBuf data) {
        this.sendHttp2Response0(status, false, data);
    }

    @Override
    protected void sendAppError(HttpResponseStatus status, ByteBuf data) {
        this.sendHttp2Response0(status, true, data);
    }

    @Override
    protected void sendRpcError(HttpResponseStatus status, ByteBuf data) {
        this.sendHttp2Response0(status, true, data);
    }

    private void sendHttp2Response0(HttpResponseStatus status, boolean error, ByteBuf data) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)status.codeAsText());
        if (this.request.getSerializeType() > 0) {
            String serialization = SerializerFactory.getAliasByCode(this.request.getSerializeType());
            headers.set((Object)"sofa_head_serialize_type", (Object)serialization);
        } else {
            headers.set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)("text/plain; charset=" + RpcConstants.DEFAULT_CHARSET.displayName()));
        }
        if (error) {
            headers.set((Object)"sofa_head_response_error", (Object)"true");
        }
        if (data != null) {
            this.encoder.writeHeaders(this.ctx, this.streamId.intValue(), headers, 0, false, this.ctx.newPromise());
            this.encoder.writeData(this.ctx, this.streamId.intValue(), data, 0, true, this.ctx.newPromise());
        } else {
            this.encoder.writeHeaders(this.ctx, this.streamId.intValue(), headers, 0, true, this.ctx.newPromise());
        }
    }
}

