/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.tools;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import org.apache.maven.artifact.Artifact;

public class ArtifactItem {
    private static final String GAV_SPLIT = ":";
    private String groupId;
    private String artifactId;
    private String version = "?";
    private String classifier;
    private String type = "jar";

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        if (this.classifier == null) {
            return String.format("%s%s%s%s%s%s%s", this.groupId, GAV_SPLIT, this.artifactId, GAV_SPLIT, this.version, GAV_SPLIT, this.type);
        }
        return String.format("%s%s%s%s%s%s%s%s%s", this.groupId, GAV_SPLIT, this.artifactId, GAV_SPLIT, this.classifier, GAV_SPLIT, this.version, GAV_SPLIT, this.type);
    }

    public boolean isSameIgnoreVersion(ArtifactItem that) {
        if (that == null) {
            return false;
        }
        return StringUtils.isSameStr((String)this.getGroupId(), (String)that.getGroupId()) && StringUtils.isSameStr((String)this.getArtifactId(), (String)that.getArtifactId()) && StringUtils.isSameStr((String)this.getClassifier(), (String)that.getClassifier());
    }

    public static ArtifactItem parseArtifactItemIgnoreVersion(String s) {
        String[] arr = new String[]{};
        if (s != null && !s.isEmpty()) {
            arr = s.split(GAV_SPLIT);
        }
        AssertUtils.isTrue((arr != null && arr.length >= 2 && arr.length <= 3 ? 1 : 0) != 0, (String)"artifact item format error: %s", (Object[])new Object[]{s});
        ArtifactItem item = new ArtifactItem();
        item.setGroupId(arr[0]);
        item.setArtifactId(arr[1]);
        if (arr.length == 3) {
            item.setClassifier(arr[3]);
        }
        return item;
    }

    public static ArtifactItem parseArtifactItemWithVersion(String s) {
        String[] arr = new String[]{};
        if (s != null && !s.isEmpty()) {
            arr = s.split(GAV_SPLIT);
        }
        AssertUtils.isTrue((arr != null && arr.length >= 3 && arr.length <= 4 ? 1 : 0) != 0, (String)"artifact item format error: %s", (Object[])new Object[]{s});
        ArtifactItem item = new ArtifactItem();
        item.setGroupId(arr[0]);
        item.setArtifactId(arr[1]);
        item.setVersion(arr[2]);
        if (arr.length == 4) {
            item.setClassifier(arr[3]);
        }
        return item;
    }

    public static ArtifactItem parseArtifactItem(Artifact artifact) {
        ArtifactItem artifactItem = new ArtifactItem();
        artifactItem.setGroupId(artifact.getGroupId());
        artifactItem.setArtifactId(artifact.getArtifactId());
        artifactItem.setClassifier(artifact.getClassifier());
        artifactItem.setVersion(artifact.getVersion());
        artifactItem.setType(artifact.getType());
        return artifactItem;
    }
}

