/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.boot.mojo;

import com.alipay.sofa.ark.boot.mojo.ArtifactsLibraries;
import com.alipay.sofa.ark.common.util.ClassUtils;
import com.alipay.sofa.ark.common.util.ParseUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.tools.ArtifactItem;
import com.alipay.sofa.ark.tools.Libraries;
import com.alipay.sofa.ark.tools.Repackager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractMojo {
    private static final String BIZ_NAME = "com.alipay.sofa.ark.bizName";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private MavenSession mavenSession;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File baseDir;
    @Parameter(defaultValue="", required=false)
    private String packExcludesConfig;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="sofa.ark.repackage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="ark-biz", readonly=true)
    private String bizClassifier;
    @Parameter(defaultValue="${project.artifactId}")
    private String bizName;
    @Parameter(defaultValue="${project.version}")
    private String bizVersion;
    @Parameter(defaultValue="100", property="sofa.ark.biz.priority")
    protected Integer priority;
    @Parameter(defaultValue="ark-executable", readonly=true)
    private String arkClassifier;
    @Parameter(defaultValue="false")
    private boolean attach;
    @Parameter
    private String mainClass;
    @Parameter
    private List<Dependency> requiresUnpack;
    private String arkVersion;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> excludes = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> excludeGroupIds = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> excludeArtifactIds = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> denyImportPackages;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> denyImportClasses;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> denyImportResources;
    @Parameter(defaultValue="")
    private LinkedHashSet<String> injectPluginDependencies = new LinkedHashSet();
    @Parameter(defaultValue="")
    private LinkedHashSet<String> injectPluginExportPackages = new LinkedHashSet();
    @Parameter(defaultValue="false")
    private boolean packageProvided;
    @Parameter(defaultValue="false")
    private boolean skipArkExecutable;
    @Parameter(defaultValue="true")
    private boolean keepArkBizJar;
    @Parameter(defaultValue="/", required=true)
    private String webContextPath;

    public void execute() throws MojoExecutionException {
        if ("war".equals(this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to war project.");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        if (StringUtils.isSameStr((String)this.arkClassifier, (String)this.bizClassifier)) {
            this.getLog().debug((CharSequence)"Executable fat jar should be different from 'plug-in' module jar.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping repackaging as configuration.");
            return;
        }
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        this.arkVersion = pluginDescriptor.getVersion();
        this.repackage();
    }

    private void repackage() throws MojoExecutionException {
        File source = this.project.getArtifact().getFile();
        File appTarget = this.getAppTargetFile();
        File moduleTarget = this.getModuleTargetFile();
        Repackager repackager = this.getRepackager(source);
        ArtifactsLibraries libraries = new ArtifactsLibraries(this.getAdditionalArtifact(), this.requiresUnpack, this.getLog());
        try {
            repackager.repackage(appTarget, moduleTarget, (Libraries)libraries);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        this.updateArtifact(appTarget, repackager.getModuleTargetFile());
    }

    private Set<Artifact> getAdditionalArtifact() throws MojoExecutionException {
        Artifact arkArtifact = this.artifactFactory.createArtifact(ArkConstants.getGroupId(), ArkConstants.getArtifactId(), this.arkVersion, ArkConstants.getScope(), ArkConstants.getType());
        try {
            this.artifactResolver.resolve(arkArtifact, this.project.getRemoteArtifactRepositories(), this.mavenSession.getLocalRepository());
            HashSet<Artifact> artifacts = new HashSet<Artifact>(Collections.singleton(arkArtifact));
            artifacts.addAll(this.filterExcludeArtifacts(this.project.getArtifacts()));
            return artifacts;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private File getAppTargetFile() {
        String classifier;
        String string = classifier = this.arkClassifier == null ? "" : this.arkClassifier.trim();
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    private File getModuleTargetFile() {
        String classifier;
        String string = classifier = this.bizClassifier == null ? "" : this.bizClassifier.trim();
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    private Repackager getRepackager(File source) {
        Repackager repackager = new Repackager(source);
        repackager.addMainClassTimeoutWarningListener((Repackager.MainClassTimeoutWarningListener)new LoggingMainClassTimeoutWarningListener());
        repackager.setMainClass(this.mainClass);
        repackager.setBizName(this.bizName);
        if (!StringUtils.isEmpty((String)System.getProperty(BIZ_NAME))) {
            repackager.setBizName(System.getProperty(BIZ_NAME));
        }
        repackager.setBizVersion(this.bizVersion);
        repackager.setPriority(String.valueOf(this.priority));
        repackager.setArkVersion(this.arkVersion);
        repackager.setDenyImportClasses(this.denyImportClasses);
        repackager.setDenyImportPackages(this.denyImportPackages);
        repackager.setDenyImportResources(this.denyImportResources);
        repackager.setInjectPluginDependencies(this.injectPluginDependencies);
        repackager.setInjectPluginExportPackages(this.injectPluginExportPackages);
        repackager.setPackageProvided(this.packageProvided);
        repackager.setSkipArkExecutable(this.skipArkExecutable);
        repackager.setKeepArkBizJar(this.keepArkBizJar);
        repackager.setBaseDir(this.baseDir);
        repackager.setWebContextPath(this.webContextPath);
        return repackager;
    }

    private void updateArtifact(File repackaged, File modulePackaged) {
        if (this.attach) {
            this.attachArtifact(repackaged, this.arkClassifier);
            this.attachArtifact(modulePackaged, this.bizClassifier);
        }
    }

    private void attachArtifact(File jarFile, String classifier) {
        this.getLog().info((CharSequence)("Attaching archive:" + jarFile + ", with classifier: " + classifier));
        this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), classifier, jarFile);
    }

    protected Set<Artifact> filterExcludeArtifacts(Set<Artifact> artifacts) {
        if (!StringUtils.isEmpty((String)this.packExcludesConfig)) {
            this.extensionExcludeArtifacts(this.baseDir + File.separator + "conf/ark" + File.separator + this.packExcludesConfig);
        }
        ArrayList<ArtifactItem> excludeList = new ArrayList<ArtifactItem>();
        for (String exclude : this.excludes) {
            ArtifactItem item = ArtifactItem.parseArtifactItemIgnoreVersion((String)exclude);
            excludeList.add(item);
        }
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact e : artifacts) {
            boolean isExclude = false;
            for (ArtifactItem exclude : excludeList) {
                if (!exclude.isSameIgnoreVersion(ArtifactItem.parseArtifactItem((Artifact)e))) continue;
                isExclude = true;
                break;
            }
            if (this.excludeGroupIds != null) {
                for (String excludeGroupId : this.excludeGroupIds) {
                    if (excludeGroupId.endsWith("*")) {
                        excludeGroupId = ClassUtils.getPackageName((String)excludeGroupId);
                    }
                    if (!e.getGroupId().startsWith(excludeGroupId)) continue;
                    isExclude = true;
                }
            }
            if (this.excludeArtifactIds != null && this.excludeArtifactIds.contains(e.getArtifactId())) {
                isExclude = true;
            }
            if (isExclude) continue;
            result.add(e);
        }
        return result;
    }

    protected void extensionExcludeArtifacts(String extraResources) {
        try {
            File configFile = new File(extraResources);
            if (configFile.exists()) {
                String dataLine;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
                while ((dataLine = bufferedReader.readLine()) != null) {
                    if (dataLine.startsWith("excludes")) {
                        ParseUtils.parseExcludeConf(this.excludes, (String)dataLine, (String)"excludes");
                        continue;
                    }
                    if (dataLine.startsWith("excludeGroupIds")) {
                        ParseUtils.parseExcludeConf(this.excludeGroupIds, (String)dataLine, (String)"excludeGroupIds");
                        continue;
                    }
                    if (!dataLine.startsWith("excludeArtifactIds")) continue;
                    ParseUtils.parseExcludeConf(this.excludeArtifactIds, (String)dataLine, (String)"excludeArtifactIds");
                }
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"failed to extension excludes artifacts.", (Throwable)ex);
        }
    }

    public static class ArkConstants {
        private static String groupId = "com.alipay.sofa";
        private static String artifactId = "sofa-ark-all";
        private static String classifier = "";
        private static String scope = "compile";
        private static String type = "jar";

        public static String getGroupId() {
            return groupId;
        }

        public static String getArtifactId() {
            return artifactId;
        }

        public static String getClassifier() {
            return classifier;
        }

        public static String getScope() {
            return scope;
        }

        public static String getType() {
            return type;
        }
    }

    private class LoggingMainClassTimeoutWarningListener
    implements Repackager.MainClassTimeoutWarningListener {
        private LoggingMainClassTimeoutWarningListener() {
        }

        public void handleTimeoutWarning(long duration, String mainMethod) {
            RepackageMojo.this.getLog().warn((CharSequence)String.format("Searching for the main-class is taking some time: %dms, consider using the mainClass configuration parameter", duration));
        }
    }
}

