/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.sofa.jraft.rpc.Connection;
import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.ConnectionClosedEventListener;
import com.alipay.sofa.jraft.rpc.impl.ConnectionInterceptor;
import com.alipay.sofa.jraft.rpc.impl.GrpcRaftRpcFactory;
import com.alipay.sofa.jraft.rpc.impl.GrpcServerHelper;
import com.alipay.sofa.jraft.rpc.impl.MarshallerRegistry;
import com.alipay.sofa.jraft.rpc.impl.RemoteAddressInterceptor;
import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.internal.ThrowUtil;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServer
implements RpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServer.class);
    private static final String EXECUTOR_NAME = "grpc-default-executor";
    private final Server server;
    private final MutableHandlerRegistry handlerRegistry;
    private final Map<String, Message> parserClasses;
    private final MarshallerRegistry marshallerRegistry;
    private final List<ServerInterceptor> serverInterceptors = new CopyOnWriteArrayList<ServerInterceptor>();
    private final List<ConnectionClosedEventListener> closedEventListeners = new CopyOnWriteArrayList<ConnectionClosedEventListener>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ExecutorService defaultExecutor;

    public GrpcServer(Server server, MutableHandlerRegistry handlerRegistry, Map<String, Message> parserClasses, MarshallerRegistry marshallerRegistry) {
        this.server = server;
        this.handlerRegistry = handlerRegistry;
        this.parserClasses = parserClasses;
        this.marshallerRegistry = marshallerRegistry;
        this.registerDefaultServerInterceptor();
    }

    public boolean init(Void opts) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("grpc server has started");
        }
        this.defaultExecutor = ThreadPoolUtil.newBuilder().poolName(EXECUTOR_NAME).enableMetric(Boolean.valueOf(true)).coreThreads(Integer.valueOf(Math.min(20, GrpcRaftRpcFactory.RPC_SERVER_PROCESSOR_POOL_SIZE / 5))).maximumThreads(Integer.valueOf(GrpcRaftRpcFactory.RPC_SERVER_PROCESSOR_POOL_SIZE)).keepAliveSeconds(Long.valueOf(60L)).workQueue(new SynchronousQueue()).threadFactory((ThreadFactory)new NamedThreadFactory("grpc-default-executor-", true)).rejectedHandler((r, executor) -> {
            throw new RejectedExecutionException("[grpc-default-executor], task " + r.toString() + " rejected from " + executor.toString());
        }).build();
        try {
            this.server.start();
        }
        catch (IOException e) {
            ThrowUtil.throwException((Throwable)e);
        }
        return true;
    }

    public void shutdown() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.defaultExecutor);
        GrpcServerHelper.shutdownAndAwaitTermination(this.server);
    }

    public void registerConnectionClosedEventListener(ConnectionClosedEventListener listener) {
        this.closedEventListeners.add(listener);
    }

    public void registerProcessor(RpcProcessor processor) {
        String interest = processor.interest();
        Message reqIns = (Message)Requires.requireNonNull((Object)this.parserClasses.get(interest), (String)("null default instance: " + interest));
        MethodDescriptor method = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)processor.interest(), (String)"_call")).setRequestMarshaller(ProtoUtils.marshaller((Message)reqIns)).setResponseMarshaller(ProtoUtils.marshaller((Message)this.marshallerRegistry.findResponseInstanceByRequest(interest))).build();
        ServerCallHandler handler = ServerCalls.asyncUnaryCall((request, responseObserver) -> {
            Executor executor;
            final SocketAddress remoteAddress = RemoteAddressInterceptor.getRemoteAddress();
            final Connection conn = ConnectionInterceptor.getCurrentConnection(this.closedEventListeners);
            RpcContext rpcCtx = new RpcContext(){

                public void sendResponse(Object responseObj) {
                    try {
                        responseObserver.onNext((Object)((Message)responseObj));
                        responseObserver.onCompleted();
                    }
                    catch (Throwable t) {
                        LOG.warn("[GRPC] failed to send response: {}.", t);
                    }
                }

                public Connection getConnection() {
                    if (conn == null) {
                        throw new IllegalStateException("fail to get connection");
                    }
                    return conn;
                }

                public String getRemoteAddress() {
                    return remoteAddress != null ? remoteAddress.toString() : null;
                }
            };
            RpcProcessor.ExecutorSelector selector = processor.executorSelector();
            if (selector != null && request instanceof RpcRequests.AppendEntriesRequest) {
                RpcRequests.AppendEntriesRequest req = (RpcRequests.AppendEntriesRequest)request;
                RpcRequests.AppendEntriesRequestHeader.Builder header = RpcRequests.AppendEntriesRequestHeader.newBuilder().setGroupId(req.getGroupId()).setPeerId(req.getPeerId()).setServerId(req.getServerId());
                executor = selector.select(interest, (Object)header.build());
            } else {
                executor = processor.executor();
            }
            if (executor == null) {
                executor = this.defaultExecutor;
            }
            if (executor != null) {
                executor.execute(() -> processor.handleRequest(rpcCtx, request));
            } else {
                processor.handleRequest(rpcCtx, request);
            }
        });
        ServerServiceDefinition serviceDef = ServerServiceDefinition.builder((String)interest).addMethod(method, handler).build();
        this.handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, (ServerInterceptor[])this.serverInterceptors.toArray(new ServerInterceptor[0])));
    }

    public int boundPort() {
        return this.server.getPort();
    }

    public void setDefaultExecutor(ExecutorService defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public Server getServer() {
        return this.server;
    }

    public MutableHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public boolean addServerInterceptor(ServerInterceptor interceptor) {
        return this.serverInterceptors.add(interceptor);
    }

    private void registerDefaultServerInterceptor() {
        this.serverInterceptors.add(new RemoteAddressInterceptor());
        this.serverInterceptors.add(new ConnectionInterceptor());
    }
}

