/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.asr;

import com.alibaba.nls.client.protocol.InputFormatEnum;
import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.SampleRateEnum;
import com.alibaba.nls.client.protocol.SpeechReqProtocol;
import com.alibaba.nls.client.protocol.asr.SpeechTranscriberListener;
import com.alibaba.nls.client.transport.ConnectionListener;
import com.alibaba.nls.client.util.IdGen;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechTranscriber
extends SpeechReqProtocol {
    static Logger logger = LoggerFactory.getLogger(SpeechTranscriber.class);
    private CountDownLatch completeLatch;
    private CountDownLatch readyLatch;
    protected SpeechTranscriberListener speechTranscriberListener;
    private static final String DEFAULT_FORMAT = "pcm";
    private static final Integer DEFAULT_SAMPLE_RATE = 16000;

    public SpeechTranscriberListener getSpeechTranscriberListener() {
        return this.speechTranscriberListener;
    }

    public String getFormat() {
        return (String)this.payload.get("format");
    }

    public void setFormat(InputFormatEnum format) {
        this.payload.put("format", format.getName());
    }

    public Integer getSampleRate() {
        return (Integer)this.payload.get("sample_rate");
    }

    public void setSampleRate(SampleRateEnum sampleRate) {
        this.payload.put("sample_rate", sampleRate.value);
    }

    public void setEnableIntermediateResult(boolean isEnable) {
        this.payload.put("enable_intermediate_result", isEnable);
    }

    public void setEnablePunctuation(boolean isEnable) {
        this.payload.put("enable_punctuation_prediction", isEnable);
    }

    public void setEnableITN(boolean enableITN) {
        this.payload.put("enable_inverse_text_normalization", enableITN);
    }

    public SpeechTranscriber(NlsClient client, SpeechTranscriberListener listener) throws Exception {
        this.conn = client.connect((ConnectionListener)listener);
        this.payload = new HashMap();
        this.header.put("namespace", "SpeechTranscriber");
        this.header.put("name", "StartTranscription");
        this.payload.put("format", DEFAULT_FORMAT);
        this.payload.put("sample_rate", DEFAULT_SAMPLE_RATE);
        listener.setSpeechTranscriber(this);
        this.speechTranscriberListener = listener;
        this.state = SpeechReqProtocol.State.STATE_CONNECTED;
    }

    public void send(byte[] data) {
        this.state.checkSend();
        try {
            this.conn.sendBinary(Arrays.copyOfRange(data, 0, data.length));
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    public void send(InputStream ins) {
        this.state.checkSend();
        try {
            byte[] bytes = new byte[8000];
            int len = 0;
            while ((len = ins.read(bytes)) > 0) {
                this.conn.sendBinary(Arrays.copyOfRange(bytes, 0, len));
            }
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    public void send(InputStream ins, int batchSize, int sleepInterval) {
        this.state.checkSend();
        try {
            byte[] bytes = new byte[batchSize];
            int len = 0;
            while ((len = ins.read(bytes)) > 0) {
                this.conn.sendBinary(Arrays.copyOfRange(bytes, 0, len));
                Thread.sleep(sleepInterval);
            }
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    void markTranscriberReady() {
        this.state = SpeechReqProtocol.State.STATE_REQUEST_CONFIRMED;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
    }

    void markTranscriberComplete() {
        this.state = SpeechReqProtocol.State.STATE_COMPLETE;
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    void markFail() {
        this.state = SpeechReqProtocol.State.STATE_FAIL;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    void markClosed() {
        this.state = SpeechReqProtocol.State.STATE_CLOSED;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    public void start() throws Exception {
        String taskId;
        this.state.checkStart();
        this.currentTaskId = taskId = IdGen.genId();
        this.setTaskId(this.currentTaskId);
        this.conn.sendText(this.serialize());
        this.state = SpeechReqProtocol.State.STATE_REQUEST_SENT;
        this.completeLatch = new CountDownLatch(1);
        this.readyLatch = new CountDownLatch(1);
        boolean result = this.readyLatch.await(10L, TimeUnit.SECONDS);
        if (!result) {
            String msg = String.format("timeout after 10 seconds waiting for start confirmation.task_id:%s,state:%s", this.currentTaskId, this.state);
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void stop() throws Exception {
        this.state.checkStop();
        SpeechReqProtocol req = new SpeechReqProtocol();
        req.header.put("task_id", this.currentTaskId);
        req.header.put("namespace", "SpeechTranscriber");
        req.header.put("name", "StopTranscription");
        req.setAppKey(this.getAppKey());
        this.conn.sendText(req.serialize());
        this.state = SpeechReqProtocol.State.STATE_STOP_SENT;
        boolean result = this.completeLatch.await(10L, TimeUnit.SECONDS);
        if (!result) {
            String msg = String.format("timeout after 10 seconds waiting for complete confirmation.task_id:%s,state:%s", this.currentTaskId, this.state);
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void close() {
        this.conn.close();
    }
}

