/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.ArrayUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.mapper.ext.WhereBuilder;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface ConfigInfoMapper
extends Mapper {
    default public MapperResult findConfigMaxId(MapperContext context) {
        return new MapperResult("SELECT MAX(id) FROM config_info", Collections.emptyList());
    }

    default public MapperResult findAllDataIdAndGroup(MapperContext context) {
        return new MapperResult("SELECT DISTINCT data_id, group_id FROM config_info", Collections.emptyList());
    }

    default public MapperResult findConfigInfoByAppCountRows(MapperContext context) {
        Object tenantId = context.getWhereParameter("tenantId");
        Object appName = context.getWhereParameter("app_name");
        String sql = "SELECT count(*) FROM config_info WHERE tenant_id LIKE ? AND app_name = ?";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{tenantId, appName}));
    }

    public MapperResult findConfigInfoByAppFetchRows(MapperContext var1);

    default public MapperResult configInfoLikeTenantCount(MapperContext context) {
        Object tenantId = context.getWhereParameter("tenantId");
        String sql = "SELECT count(*) FROM config_info WHERE tenant_id LIKE ?";
        return new MapperResult(sql, Collections.singletonList(tenantId));
    }

    public MapperResult getTenantIdList(MapperContext var1);

    public MapperResult getGroupIdList(MapperContext var1);

    public MapperResult findAllConfigKey(MapperContext var1);

    public MapperResult findAllConfigInfoBaseFetchRows(MapperContext var1);

    public MapperResult findAllConfigInfoFragment(MapperContext var1);

    default public MapperResult findChangeConfig(MapperContext context) {
        String sql = "SELECT id, data_id, group_id, tenant_id, app_name,md5, gmt_modified, encrypted_data_key FROM config_info WHERE gmt_modified >= ? and id > ? order by id  limit ? ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("startTime"), context.getWhereParameter("lastMaxId"), context.getWhereParameter("pageSize")}));
    }

    default public MapperResult findChangeConfigCountRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenant");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        Timestamp startTime = (Timestamp)context.getWhereParameter("startTime");
        Timestamp endTime = (Timestamp)context.getWhereParameter("endTime");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        Object where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = (String)where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = (String)where + " AND group_id LIKE ? ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            where = (String)where + " AND tenant_id = ? ";
            paramList.add(tenant);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = (String)where + " AND app_name = ? ";
            paramList.add(appName);
        }
        if (startTime != null) {
            where = (String)where + " AND gmt_modified >=? ";
            paramList.add(startTime);
        }
        if (endTime != null) {
            where = (String)where + " AND gmt_modified <=? ";
            paramList.add(endTime);
        }
        return new MapperResult("SELECT count(*) FROM config_info WHERE " + (String)where, paramList);
    }

    public MapperResult findChangeConfigFetchRows(MapperContext var1);

    public MapperResult listGroupKeyMd5ByPageFetchRows(MapperContext var1);

    default public MapperResult findAllConfigInfo4Export(MapperContext context) {
        List ids = (List)context.getWhereParameter("ids");
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,c_schema,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            where.append(" id IN (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append('?');
                paramList.add(ids.get(i));
            }
            where.append(") ");
        } else {
            where.append(" tenant_id = ? ");
            paramList.add(context.getWhereParameter("tenantId"));
            String dataId = (String)context.getWhereParameter("dataId");
            String group = (String)context.getWhereParameter("groupId");
            String appName = (String)context.getWhereParameter("app_name");
            if (StringUtils.isNotBlank((String)dataId)) {
                where.append(" AND data_id LIKE ? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((String)group)) {
                where.append(" AND group_id= ? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                where.append(" AND app_name= ? ");
                paramList.add(appName);
            }
        }
        return new MapperResult(sql + where, paramList);
    }

    default public MapperResult findConfigInfoBaseLikeCountRows(MapperContext context) {
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter("content");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='" + NamespaceUtil.getNamespaceDefaultId() + "' ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " AND content LIKE ? ";
            paramList.add(content);
        }
        return new MapperResult("SELECT count(*) FROM config_info WHERE " + where, paramList);
    }

    public MapperResult findConfigInfoBaseLikeFetchRows(MapperContext var1);

    default public MapperResult findConfigInfo4PageCountRows(MapperContext context) {
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter("content");
        String appName = (String)context.getWhereParameter("app_name");
        String tenantId = (String)context.getWhereParameter("tenantId");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlCount = "SELECT count(*) FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        paramList.add(tenantId);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
            paramList.add(dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
            paramList.add(group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
            paramList.add(content);
        }
        return new MapperResult("SELECT count(*) FROM config_info" + where, paramList);
    }

    public MapperResult findConfigInfo4PageFetchRows(MapperContext var1);

    public MapperResult findConfigInfoBaseByGroupFetchRows(MapperContext var1);

    default public MapperResult findConfigInfoLike4PageCountRows(MapperContext context) {
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter("content");
        String appName = (String)context.getWhereParameter("app_name");
        String tenantId = (String)context.getWhereParameter("tenantId");
        Object[] types = (String[])context.getWhereParameter("type");
        WhereBuilder where = new WhereBuilder("SELECT count(*) FROM config_info");
        where.like("tenant_id", tenantId);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.and().like("data_id", dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.and().like("group_id", group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.and().eq("app_name", appName);
        }
        if (StringUtils.isNotBlank((String)content)) {
            where.and().like("content", content);
        }
        if (!ArrayUtils.isEmpty((Object[])types)) {
            where.and().in("type", types);
        }
        return where.build();
    }

    public MapperResult findConfigInfoLike4PageFetchRows(MapperContext var1);

    public MapperResult findAllConfigInfoFetchRows(MapperContext var1);

    default public MapperResult findConfigInfosByIds(MapperContext context) {
        List ids = (List)context.getWhereParameter("ids");
        StringBuilder sql = new StringBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE ");
        sql.append("id IN (");
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
            paramList.add(ids.get(i));
        }
        sql.append(") ");
        return new MapperResult(sql.toString(), paramList);
    }

    default public MapperResult removeConfigInfoByIdsAtomic(MapperContext context) {
        List ids = (List)context.getWhereParameter("ids");
        StringBuilder sql = new StringBuilder("DELETE FROM config_info WHERE ");
        sql.append("id IN (");
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append('?');
            paramList.add(ids.get(i));
        }
        sql.append(") ");
        return new MapperResult(sql.toString(), paramList);
    }

    default public MapperResult updateConfigInfoAtomicCas(MapperContext context) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("content"));
        paramList.add(context.getUpdateParameter("md5"));
        paramList.add(context.getUpdateParameter("srcIp"));
        paramList.add(context.getUpdateParameter("srcUser"));
        paramList.add(context.getUpdateParameter("app_name"));
        paramList.add(context.getUpdateParameter("cDesc"));
        paramList.add(context.getUpdateParameter("cUse"));
        paramList.add(context.getUpdateParameter("effect"));
        paramList.add(context.getUpdateParameter("type"));
        paramList.add(context.getUpdateParameter("cSchema"));
        paramList.add(context.getUpdateParameter("encrypted_data_key"));
        paramList.add(context.getWhereParameter("dataId"));
        paramList.add(context.getWhereParameter("groupId"));
        paramList.add(context.getWhereParameter("tenantId"));
        paramList.add(context.getWhereParameter("md5"));
        String sql = "UPDATE config_info SET content=?, md5=?, src_ip=?, src_user=?, gmt_modified=" + this.getFunction("NOW()") + ", app_name=?, c_desc=?, c_use=?, effect=?, type=?, c_schema=?, encrypted_data_key=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? OR md5 IS NULL OR md5='')";
        return new MapperResult(sql, paramList);
    }

    @Override
    default public String getTableName() {
        return "config_info";
    }
}

