/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.notify;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisher;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPublisher
extends Thread
implements EventPublisher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NotifyCenter.class);
    private volatile boolean initialized = false;
    private volatile boolean shutdown = false;
    private Class<? extends Event> eventType;
    protected final ConcurrentHashSet<Subscriber> subscribers = new ConcurrentHashSet();
    private int queueMaxSize = -1;
    private BlockingQueue<Event> queue;
    protected volatile Long lastEventSequence = -1L;
    private static final AtomicReferenceFieldUpdater<DefaultPublisher, Long> UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPublisher.class, Long.class, "lastEventSequence");

    @Override
    public void init(Class<? extends Event> type, int bufferSize) {
        this.setDaemon(true);
        this.setName("nacos.publisher-" + type.getName());
        this.eventType = type;
        this.queueMaxSize = bufferSize;
        if (this.queueMaxSize == -1) {
            this.queueMaxSize = NotifyCenter.ringBufferSize;
        }
        this.queue = new ArrayBlockingQueue<Event>(this.queueMaxSize);
        this.start();
    }

    public ConcurrentHashSet<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    @Override
    public synchronized void start() {
        if (!this.initialized) {
            super.start();
            this.initialized = true;
        }
    }

    @Override
    public long currentEventSize() {
        return this.queue.size();
    }

    @Override
    public void run() {
        this.openEventHandler();
    }

    void openEventHandler() {
        try {
            for (int waitTimes = 60; !this.shutdown && !this.hasSubscriber() && waitTimes > 0; --waitTimes) {
                ThreadUtils.sleep(1000L);
            }
            while (!this.shutdown) {
                Event event = this.queue.take();
                this.receiveEvent(event);
                UPDATER.compareAndSet(this, this.lastEventSequence, Math.max(this.lastEventSequence, event.sequence()));
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Event listener exception : ", ex);
        }
    }

    private boolean hasSubscriber() {
        return CollectionUtils.isNotEmpty(this.subscribers);
    }

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public void removeSubscriber(Subscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    public boolean publish(Event event) {
        this.checkIsStart();
        boolean success = this.queue.offer(event);
        if (!success) {
            LOGGER.warn("Unable to plug in due to interruption, synchronize sending time, event : {}", (Object)event);
            this.receiveEvent(event);
            return true;
        }
        return true;
    }

    void checkIsStart() {
        if (!this.initialized) {
            throw new IllegalStateException("Publisher does not start");
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.queue.clear();
        this.interrupt();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    void receiveEvent(Event event) {
        long currentEventSequence = event.sequence();
        if (!this.hasSubscriber()) {
            LOGGER.warn("[NotifyCenter] the {} is lost, because there is no subscriber.", (Object)event);
            return;
        }
        for (Subscriber subscriber : this.subscribers) {
            if (!subscriber.scopeMatches(event)) continue;
            if (subscriber.ignoreExpireEvent() && this.lastEventSequence > currentEventSequence) {
                LOGGER.debug("[NotifyCenter] the {} is unacceptable to this subscriber, because had expire", event.getClass());
                continue;
            }
            this.notifySubscriber(subscriber, event);
        }
    }

    @Override
    public void notifySubscriber(Subscriber subscriber, Event event) {
        LOGGER.debug("[NotifyCenter] the {} will received by {}", (Object)event, (Object)subscriber);
        Runnable job = () -> subscriber.onEvent(event);
        Executor executor = subscriber.executor();
        if (executor != null) {
            executor.execute(job);
        } else {
            try {
                job.run();
            }
            catch (Throwable e) {
                LOGGER.error("Event callback exception: ", e);
            }
        }
    }
}

