/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.model.v2;

public enum ErrorCode {
    SUCCESS(0, "success"),
    PARAMETER_MISSING(10000, "parameter missing"),
    ACCESS_DENIED(10001, "access denied"),
    DATA_ACCESS_ERROR(10002, "data access error"),
    TENANT_PARAM_ERROR(20001, "'tenant' parameter error"),
    PARAMETER_VALIDATE_ERROR(20002, "parameter validate error"),
    MEDIA_TYPE_ERROR(20003, "MediaType Error"),
    RESOURCE_NOT_FOUND(20004, "resource not found"),
    RESOURCE_CONFLICT(20005, "resource conflict"),
    CONFIG_LISTENER_IS_NULL(20006, "config listener is null"),
    CONFIG_LISTENER_ERROR(20007, "config listener error"),
    INVALID_DATA_ID(20008, "invalid dataId"),
    PARAMETER_MISMATCH(20009, "parameter mismatch"),
    CONFIG_GRAY_OVER_MAX_VERSION_COUNT(20010, "config gray version version over max count"),
    CONFIG_GRAY_RULE_FORMAT_INVALID(20011, "config gray rule format invalid"),
    CONFIG_GRAY_VERSION_INVALID(20012, "config gray rule version invalid"),
    CONFIG_GRAY_NAME_UNRECOGNIZED_ERROR(20013, "config gray name not recognized"),
    OVER_CLUSTER_QUOTA(5031, "cluster capacity reach quota"),
    OVER_GROUP_QUOTA(5032, "group capacity reach quota"),
    OVER_TENANT_QUOTA(5033, "tenant capacity reach quota"),
    OVER_MAX_SIZE(5034, "config content size is over limit"),
    SERVICE_NAME_ERROR(21000, "service name error"),
    WEIGHT_ERROR(21001, "weight error"),
    INSTANCE_METADATA_ERROR(21002, "instance metadata error"),
    INSTANCE_NOT_FOUND(21003, "instance not found"),
    INSTANCE_ERROR(21004, "instance error"),
    SERVICE_METADATA_ERROR(21005, "service metadata error"),
    SELECTOR_ERROR(21006, "selector error"),
    SERVICE_ALREADY_EXIST(21007, "service already exist"),
    SERVICE_NOT_EXIST(21008, "service not exist"),
    SERVICE_DELETE_FAILURE(21009, "service delete failure"),
    HEALTHY_PARAM_MISS(21010, "healthy param miss"),
    HEALTH_CHECK_STILL_RUNNING(21011, "health check still running"),
    ILLEGAL_NAMESPACE(22000, "illegal namespace"),
    NAMESPACE_NOT_EXIST(22001, "namespace not exist"),
    NAMESPACE_ALREADY_EXIST(22002, "namespace already exist"),
    ILLEGAL_STATE(23000, "illegal state"),
    NODE_INFO_ERROR(23001, "node info error"),
    NODE_DOWN_FAILURE(23002, "node down failure"),
    SERVER_ERROR(30000, "server error"),
    API_DEPRECATED(40000, "API deprecated."),
    API_FUNCTION_DISABLED(40001, "API function disabled."),
    MCP_SERVER_NOT_FOUND(50000, "MCP server not found"),
    MCP_SEVER_VERSION_NOT_FOUND(50001, "MCP server version not found"),
    MCP_SERVER_VERSION_EXIST(50002, "MCP server version has existed"),
    MCP_SERVER_REF_ENDPOINT_SERVICE_NOT_FOUND(50003, "MCP server ref endpoint service not found"),
    METADATA_ILLEGAL(100002, "Imported metadata is invalid"),
    DATA_VALIDATION_FAILED(100003, "No valid data was read"),
    PARSING_DATA_FAILED(100004, "Failed to parse data"),
    DATA_EMPTY(100005, "Imported file data is empty"),
    NO_SELECTED_CONFIG(100006, "No configuration selected"),
    FUZZY_WATCH_PATTERN_OVER_LIMIT(50310, "fuzzy watch pattern over limit"),
    FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT(50311, "fuzzy watch pattern matched count over limit");

    private final Integer code;
    private final String msg;

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static ErrorCode getErrorCode(String name) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!errorCode.name().equals(name)) continue;
            return errorCode;
        }
        return null;
    }

    private ErrorCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}

