/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.util.Random;

public class RandomUtils {
    private static final Random RANDOM = new Random();

    public static long nextLong(long startInclusive, long endExclusive) {
        RandomUtils.checkParameters(startInclusive, endExclusive);
        long diff = endExclusive - startInclusive;
        if (diff == 0L) {
            return startInclusive;
        }
        return (long)((double)startInclusive + (double)diff * RANDOM.nextDouble());
    }

    public static int nextInt(int startInclusive, int endExclusive) {
        RandomUtils.checkParameters(startInclusive, endExclusive);
        int diff = endExclusive - startInclusive;
        if (diff == 0) {
            return startInclusive;
        }
        return startInclusive + RANDOM.nextInt(diff);
    }

    private static void checkParameters(long startInclusive, long endExclusive) {
        if (endExclusive < startInclusive) {
            throw new IllegalArgumentException("startInclusive must be less than or equal to the endExclusive.");
        }
        if (startInclusive < 0L) {
            throw new IllegalArgumentException("Both parameters must be non-negative");
        }
    }
}

