/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.identify;

import com.alibaba.nacos.client.utils.StringUtils;

public class STSConfig {
    private static final String RAM_SECURITY_CREDENTIALS_URL = "";
    private String ramRoleName;
    private int timeToRefreshInMillisecond = 180000;
    private String securityCredentialsUrl;
    private String securityCredentials;
    private boolean cacheSecurityCredentials = true;

    private STSConfig() {
        String cacheSecurityCredentials;
        String securityCredentialsUrl;
        String securityCredentials;
        String timeToRefreshInMillisecond;
        String ramRoleName = System.getProperty("ram.role.name");
        if (!StringUtils.isBlank(ramRoleName)) {
            this.setRamRoleName(ramRoleName);
        }
        if (!StringUtils.isBlank(timeToRefreshInMillisecond = System.getProperty("time.to.refresh.in.millisecond"))) {
            this.setTimeToRefreshInMillisecond(Integer.parseInt(timeToRefreshInMillisecond));
        }
        if (!StringUtils.isBlank(securityCredentials = System.getProperty("security.credentials"))) {
            this.setSecurityCredentials(securityCredentials);
        }
        if (!StringUtils.isBlank(securityCredentialsUrl = System.getProperty("security.credentials.url"))) {
            this.setSecurityCredentialsUrl(securityCredentialsUrl);
        }
        if (!StringUtils.isBlank(cacheSecurityCredentials = System.getProperty("cache.security.credentials"))) {
            this.setCacheSecurityCredentials(Boolean.valueOf(cacheSecurityCredentials));
        }
    }

    public static STSConfig getInstance() {
        return Singleton.INSTANCE;
    }

    public String getRamRoleName() {
        return this.ramRoleName;
    }

    public void setRamRoleName(String ramRoleName) {
        this.ramRoleName = ramRoleName;
    }

    public int getTimeToRefreshInMillisecond() {
        return this.timeToRefreshInMillisecond;
    }

    public void setTimeToRefreshInMillisecond(int timeToRefreshInMillisecond) {
        this.timeToRefreshInMillisecond = timeToRefreshInMillisecond;
    }

    public String getSecurityCredentialsUrl() {
        if (this.securityCredentialsUrl == null && this.ramRoleName != null) {
            return RAM_SECURITY_CREDENTIALS_URL + this.ramRoleName;
        }
        return this.securityCredentialsUrl;
    }

    public void setSecurityCredentialsUrl(String securityCredentialsUrl) {
        this.securityCredentialsUrl = securityCredentialsUrl;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public boolean isSTSOn() {
        return StringUtils.isNotEmpty(this.getSecurityCredentials()) || StringUtils.isNotEmpty(this.getSecurityCredentialsUrl());
    }

    public boolean isCacheSecurityCredentials() {
        return this.cacheSecurityCredentials;
    }

    public void setCacheSecurityCredentials(boolean cacheSecurityCredentials) {
        this.cacheSecurityCredentials = cacheSecurityCredentials;
    }

    private static class Singleton {
        private static final STSConfig INSTANCE = new STSConfig();

        private Singleton() {
        }
    }
}

