/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.provider;

import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.provider.KmsCredentialsProvider;
import com.alibaba.nacos.common.utils.StringUtils;
import com.aliyun.credentials.models.Config;
import java.util.Properties;

public class RamRoleArnKmsCredentialsProvider
implements KmsCredentialsProvider {
    private String accessKey;
    private String secretKey;
    private String roleArn;
    private String roleSessionName;

    @Override
    public boolean matchProvider(Properties properties) {
        this.accessKey = properties.getProperty("kmsExtensionAccessKey", System.getProperty("kmsExtensionAccessKey", System.getenv("kmsExtensionAccessKey")));
        if (StringUtils.isBlank((CharSequence)this.accessKey)) {
            this.accessKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_ID);
        }
        this.secretKey = properties.getProperty("kmsExtensionSecretKey", System.getProperty("kmsExtensionSecretKey", System.getenv("kmsExtensionSecretKey")));
        if (StringUtils.isBlank((CharSequence)this.secretKey)) {
            this.secretKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_SECRET);
        }
        this.roleArn = properties.getProperty("kmsRoleArn", System.getProperty("kmsRoleArn", System.getenv("kmsRoleArn")));
        if (StringUtils.isBlank((CharSequence)this.roleArn)) {
            this.roleArn = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_ARN);
        }
        this.roleSessionName = properties.getProperty("kmsRoleSessionName", System.getProperty("kmsRoleSessionName", System.getenv("kmsRoleSessionName")));
        if (StringUtils.isBlank((CharSequence)this.roleSessionName)) {
            this.roleSessionName = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_NAME);
        }
        return StringUtils.isNotBlank((String)this.accessKey) && StringUtils.isNotBlank((String)this.secretKey) && StringUtils.isNotBlank((String)this.roleArn) && StringUtils.isNotBlank((String)this.roleSessionName);
    }

    @Override
    public Config generateCredentialsConfig(Properties properties) {
        String roleSessionExpiration;
        Config config = new Config();
        config.setType("ram_role_arn");
        config.setAccessKeyId(this.accessKey);
        config.setAccessKeySecret(this.secretKey);
        config.setRoleArn(this.roleArn);
        config.setRoleSessionName(this.roleSessionName);
        String policy = properties.getProperty("kmsPolicy", System.getProperty("kmsPolicy", System.getenv("kmsPolicy")));
        if (StringUtils.isBlank((CharSequence)policy)) {
            policy = this.getNacosProperties(properties, ExtensionAuthPropertyKey.POLICY);
        }
        if (StringUtils.isNotBlank((String)policy)) {
            config.setPolicy(policy);
        }
        if (StringUtils.isBlank((CharSequence)(roleSessionExpiration = properties.getProperty("kmsRoleSessionExpiration", System.getProperty("kmsRoleSessionExpiration", System.getenv("kmsRoleSessionExpiration")))))) {
            roleSessionExpiration = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_EXPIRATION);
        }
        if (StringUtils.isNotBlank((String)roleSessionExpiration)) {
            config.setRoleSessionExpiration(Integer.valueOf(Integer.parseInt(roleSessionExpiration)));
        }
        return config;
    }
}

