/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.provider;

import com.alibaba.nacos.client.aliyun.provider.KmsCredentialsProvider;
import com.alibaba.nacos.common.utils.StringUtils;
import com.aliyun.credentials.models.Config;
import java.util.Properties;

public class AccessKeyCredentialsProvider
implements KmsCredentialsProvider {
    private String accessKey;
    private String secretKey;

    @Override
    public boolean matchProvider(Properties properties) {
        this.accessKey = properties.getProperty("kmsAccessKey", System.getProperty("kmsAccessKey", System.getenv("kmsAccessKey")));
        if (StringUtils.isBlank((CharSequence)this.accessKey)) {
            this.accessKey = properties.getProperty("accessKey", System.getProperty("accessKey", System.getenv("accessKey")));
        }
        this.secretKey = properties.getProperty("kmsSecretKey", System.getProperty("kmsSecretKey", System.getenv("kmsSecretKey")));
        if (StringUtils.isBlank((CharSequence)this.secretKey)) {
            this.secretKey = properties.getProperty("secretKey", System.getProperty("secretKey", System.getenv("secretKey")));
        }
        return !StringUtils.isBlank((CharSequence)this.accessKey) && !StringUtils.isBlank((CharSequence)this.secretKey);
    }

    @Override
    public Config generateCredentialsConfig(Properties properties) {
        Config credentialConfig = new Config();
        credentialConfig.setType("access_key");
        credentialConfig.setAccessKeyId(this.accessKey);
        credentialConfig.setAccessKeySecret(this.secretKey);
        return credentialConfig;
    }
}

