/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.api.utils.StringUtils;
import com.aliyuncs.exceptions.ClientException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KmsUtils.class);
    public static final String REJECTED_THROTTLING = "Rejected.Throttling";
    public static final String SERVICE_UNAVAILABLE_TEMPORARY = "ServiceUnavailableTemporary";
    public static final String INTERNAL_FAILURE = "InternalFailure";
    public static final String SDK_READ_TIMEOUT = "SDK.ReadTimeout";
    public static final String SDK_SERVER_UNREACHABLE = "SDK.ServerUnreachable";

    public static boolean judgeNeedBackoff(ClientException e) {
        return REJECTED_THROTTLING.equals(e.getErrCode()) || SERVICE_UNAVAILABLE_TEMPORARY.equals(e.getErrCode()) || INTERNAL_FAILURE.equals(e.getErrCode());
    }

    public static boolean judgeNeedRecoveryException(ClientException e) {
        return SDK_READ_TIMEOUT.equals(e.getErrCode()) || SDK_SERVER_UNREACHABLE.equals(e.getErrCode()) || KmsUtils.judgeNeedBackoff(e);
    }

    public static int parsePropertyValue(Properties properties, String propertyName, int defaultValueInt) {
        String propertyValueString = properties.getProperty(propertyName, System.getProperty(propertyName, System.getenv(propertyName)));
        int resultValue = defaultValueInt;
        if (!StringUtils.isBlank((CharSequence)propertyValueString)) {
            try {
                resultValue = Integer.parseInt(propertyValueString);
            }
            catch (Exception e) {
                LOGGER.warn("parse {} failed: {}\n. use default value {}.", new Object[]{propertyName, e.getMessage(), defaultValueInt});
            }
        }
        return resultValue;
    }

    public static boolean parsePropertyValue(Properties properties, String propertyName, boolean defaultValueInt) {
        String propertyValueString = properties.getProperty(propertyName, System.getProperty(propertyName, System.getenv(propertyName)));
        boolean resultValue = defaultValueInt;
        if (!StringUtils.isBlank((CharSequence)propertyValueString)) {
            try {
                resultValue = Boolean.parseBoolean(propertyValueString);
            }
            catch (Exception e) {
                LOGGER.warn("parse {} failed: {}\n. use default value {}.", new Object[]{propertyName, e.getMessage(), defaultValueInt});
            }
        }
        return resultValue;
    }

    public static String getKeySpecByDataIdPrefix(String dataId) {
        if (dataId.startsWith("cipher-kms-aes-128-")) {
            return "AES_128";
        }
        if (dataId.startsWith("cipher-kms-aes-256-")) {
            return "AES_256";
        }
        return null;
    }
}

