/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.logger.slf4j;

import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.option.ActivateOption;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.middleware.logger.support.LoggerSupport;
import com.taobao.middleware.logger.util.MessageUtil;
import java.lang.reflect.Constructor;

public class Slf4jLogger
extends LoggerSupport
implements Logger {
    private static boolean CanUseEncoder = false;
    private org.slf4j.Logger delegate;

    public Slf4jLogger(org.slf4j.Logger delegate) {
        super(delegate);
        if (delegate == null) {
            throw new IllegalArgumentException("delegate Logger is null");
        }
        this.delegate = delegate;
        String activateOptionClass = null;
        if (delegate.getClass().getName().equals("ch.qos.logback.classic.Logger")) {
            activateOptionClass = CanUseEncoder ? "com.taobao.middleware.logger.option.LogbackActivateOption" : "com.taobao.middleware.logger.option.Logback918ActivateOption";
        } else if (delegate.getClass().getName().equals("org.slf4j.impl.Log4jLoggerAdapter")) {
            activateOptionClass = "com.taobao.middleware.logger.option.Slf4jLog4jAdapterActivateOption";
        }
        try {
            Class<?> clazz = Class.forName(activateOptionClass);
            Constructor<?> c = clazz.getConstructor(Object.class);
            this.activateOption = (ActivateOption)c.newInstance(delegate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("delegate must be logback impl or slf4j-log4j impl", e);
        }
    }

    @Override
    public void debug(String context, String message) {
        if (this.isDebugEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.debug(MessageUtil.getMessage(context, message));
        }
    }

    @Override
    public void debug(String context, String format, Object ... args) {
        if (this.isDebugEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.debug(MessageUtil.getMessage(context, format), args);
        }
    }

    @Override
    public void info(String context, String message) {
        if (this.isInfoEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.info(MessageUtil.getMessage(context, message));
        }
    }

    @Override
    public void info(String context, String format, Object ... args) {
        if (this.isInfoEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.info(MessageUtil.getMessage(context, format), args);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.warn(MessageUtil.getMessage(null, message), t);
        }
    }

    @Override
    public void warn(String context, String message) {
        if (this.isWarnEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.warn(MessageUtil.getMessage(context, message));
        }
    }

    @Override
    public void warn(String context, String format, Object ... args) {
        if (this.isWarnEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.warn(MessageUtil.getMessage(context, format), args);
        }
    }

    @Override
    public void error(String context, String errorCode, String message) {
        if (this.isErrorEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.error(MessageUtil.getMessage(context, errorCode, message));
        }
    }

    @Override
    public void error(String context, String errorCode, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            message = LoggerHelper.getResourceBundleString(this.getProductName(), message);
            this.delegate.error(MessageUtil.getMessage(context, errorCode, message), t);
        }
    }

    @Override
    public void error(String context, String errorCode, String format, Object ... args) {
        if (this.isErrorEnabled()) {
            format = LoggerHelper.getResourceBundleString(this.getProductName(), format);
            this.delegate.error(MessageUtil.getMessage(context, errorCode, format), args);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    static {
        try {
            Class.forName("ch.qos.logback.classic.encoder.PatternLayoutEncoder");
            CanUseEncoder = true;
        }
        catch (ClassNotFoundException e) {
            CanUseEncoder = false;
        }
    }
}

