/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.HttpInput;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.ArrayQueue;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.log.Log;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.io.InterruptedIOException;

public abstract class QueuedHttpInput<T>
extends HttpInput<T> {
    private static final Logger LOG = Log.getLogger(QueuedHttpInput.class);
    private final ArrayQueue<T> _inputQ = new ArrayQueue(this.lock());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void content(T item) {
        Object object = this.lock();
        synchronized (object) {
            boolean wasEmpty = this._inputQ.isEmpty();
            this._inputQ.add(item);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} queued {}", this, item);
            }
            if (wasEmpty && !this.onAsyncRead()) {
                this.lock().notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            T item = this._inputQ.pollUnsafe();
            while (item != null) {
                this.onContentConsumed(item);
                item = this._inputQ.pollUnsafe();
            }
            super.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T nextContent() {
        Object object = this.lock();
        synchronized (object) {
            T item = this._inputQ.peekUnsafe();
            while (item != null && this.remaining(item) == 0) {
                this._inputQ.pollUnsafe();
                this.onContentConsumed(item);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} consumed {}", this, item);
                }
                item = this._inputQ.peekUnsafe();
            }
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blockForContent() throws IOException {
        Object object = this.lock();
        synchronized (object) {
            while (this._inputQ.isEmpty() && !this.isFinished() && !this.isEOF()) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} waiting for content", this);
                    }
                    this.lock().wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        }
    }

    protected abstract void onContentConsumed(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void earlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            super.earlyEOF();
            this.lock().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageComplete() {
        Object object = this.lock();
        synchronized (object) {
            super.messageComplete();
            this.lock().notify();
        }
    }
}

