/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Connector;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.HttpConfiguration;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.server.Request;
import java.util.Objects;

public class HostHeaderCustomizer
implements HttpConfiguration.Customizer {
    private final String serverName;
    private final int serverPort;

    public HostHeaderCustomizer(String serverName) {
        this(serverName, 0);
    }

    public HostHeaderCustomizer(String serverName, int serverPort) {
        this.serverName = Objects.requireNonNull(serverName);
        this.serverPort = serverPort;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        if (request.getHeader("Host") == null) {
            request.setServerName(this.serverName);
            if (this.serverPort > 0) {
                request.setServerPort(this.serverPort);
            }
        }
    }
}

