/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.resource;

import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.iterator.MultiDimensionalIterator;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.iterator.TransformingIterator;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.resource.ResourceFinder;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.resource.ZipFileResourceFinder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.ZipFile;

public class JarDirectoriesResourceFinder
extends LazyMultiResourceFinder {
    public JarDirectoriesResourceFinder(File[] directories) {
        super(new MultiDimensionalIterator(new TransformingIterator(Arrays.asList(directories).iterator()){

            protected Object transform(Object o) {
                File directory = (File)o;
                if (!directory.exists()) {
                    return Collections.EMPTY_LIST.iterator();
                }
                File[] jarFiles = directory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                return new TransformingIterator(Arrays.asList(jarFiles).iterator()){

                    protected Object transform(Object o) {
                        File jarFile = (File)o;
                        try {
                            return new ZipFileResourceFinder(new ZipFile(jarFile));
                        }
                        catch (IOException e) {
                            return ResourceFinder.EMPTY_RESOURCE_FINDER;
                        }
                    }
                };
            }
        }, 2));
    }
}

