/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperandCountRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.Collections;
import java.util.List;

public class SameOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final int nOperands;

    public SameOperandTypeChecker(int nOperands) {
        this.nOperands = nOperands;
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.checkOperandTypesImpl(callBinding, throwOnFailure, callBinding);
    }

    protected List<Integer> getOperandList(int operandCount) {
        return this.nOperands == -1 ? Util.range(0, operandCount) : Util.range(0, this.nOperands);
    }

    protected boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, SqlCallBinding callBinding) {
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        assert (!throwOnFailure || callBinding != null);
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 0 && !SqlTypeUtil.isComparable(types[i], types[prev])) {
                if (!throwOnFailure) {
                    return false;
                }
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    public boolean checkOperandTypes(SqlOperatorBinding operatorBinding) {
        return this.checkOperandTypesImpl(operatorBinding, false, null);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        if (this.nOperands == -1) {
            return SqlOperandCountRanges.any();
        }
        return SqlOperandCountRanges.of(this.nOperands);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        String typeName = this.getTypeName();
        return SqlUtil.getAliasedSignature(op, opName, this.nOperands == -1 ? ImmutableList.of(typeName, typeName, "...") : Collections.nCopies(this.nOperands, typeName));
    }

    protected String getTypeName() {
        return "EQUIVALENT_TYPE";
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
        throw new UnsupportedOperationException();
    }
}

