/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Ord;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunctionCategory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperandCountRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.ReturnTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.math.BigDecimal;
import java.util.List;

public class SqlSubstringFunction
extends SqlFunction {
    SqlSubstringFunction() {
        super("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} FROM {2})";
            }
            case 3: {
                return "{0}({1} FROM {2} FOR {3})";
            }
        }
        throw new AssertionError();
    }

    @Override
    public String getAllowedSignatures(String opName) {
        StringBuilder ret = new StringBuilder();
        for (Ord<SqlTypeName> typeName : Ord.zip(SqlTypeName.STRING_TYPES)) {
            if (typeName.i > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of(typeName.e, SqlTypeName.INTEGER)));
            ret.append(NL);
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of(typeName.e, SqlTypeName.INTEGER, SqlTypeName.INTEGER)));
        }
        return ret.toString();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlValidator validator = callBinding.getValidator();
        SqlValidatorScope scope = callBinding.getScope();
        List<SqlNode> operands = callBinding.operands();
        int n = operands.size();
        assert (3 == n || 2 == n);
        if (!OperandTypes.STRING.checkSingleOperandType(callBinding, operands.get(0), 0, throwOnFailure)) {
            return false;
        }
        if (2 == n) {
            if (!OperandTypes.NUMERIC.checkSingleOperandType(callBinding, operands.get(1), 0, throwOnFailure)) {
                return false;
            }
        } else {
            RelDataType t1 = validator.deriveType(scope, operands.get(1));
            RelDataType t2 = validator.deriveType(scope, operands.get(2));
            if (SqlTypeUtil.inCharFamily(t1)) {
                if (!OperandTypes.STRING.checkSingleOperandType(callBinding, operands.get(1), 0, throwOnFailure)) {
                    return false;
                }
                if (!OperandTypes.STRING.checkSingleOperandType(callBinding, operands.get(2), 0, throwOnFailure)) {
                    return false;
                }
                if (!SqlTypeUtil.isCharTypeComparable(callBinding, operands, throwOnFailure)) {
                    return false;
                }
            } else {
                if (!OperandTypes.NUMERIC.checkSingleOperandType(callBinding, operands.get(1), 0, throwOnFailure)) {
                    return false;
                }
                if (!OperandTypes.NUMERIC.checkSingleOperandType(callBinding, operands.get(2), 0, throwOnFailure)) {
                    return false;
                }
            }
            if (!SqlTypeUtil.inSameFamily(t1, t2)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        if (3 == call.operandCount()) {
            writer.sep("FOR");
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        SqlMonotonicity mono0;
        if (call.getOperandCount() == 3 && (mono0 = call.getOperandMonotonicity(0)) != SqlMonotonicity.NOT_MONOTONIC && call.getOperandMonotonicity(1) == SqlMonotonicity.CONSTANT && call.getOperandLiteralValue(1, BigDecimal.class).equals(BigDecimal.ZERO) && call.getOperandMonotonicity(2) == SqlMonotonicity.CONSTANT) {
            return mono0.unstrict();
        }
        return super.getMonotonicity(call);
    }
}

