/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlFunctionCategory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperatorBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSyntax;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.OperandTypes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;

public class SqlAbstractTimeFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.or(OperandTypes.POSITIVE_INTEGER_LITERAL, OperandTypes.NILADIC);
    private final SqlTypeName typeName;

    protected SqlAbstractTimeFunction(String name, SqlTypeName typeName) {
        super(name, SqlKind.OTHER_FUNCTION, null, null, OTC_CUSTOM, SqlFunctionCategory.TIMEDATE);
        this.typeName = typeName;
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_ID;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type;
        int precision = 0;
        if (opBinding.getOperandCount() == 1 && SqlTypeUtil.isNumeric(type = opBinding.getOperandType(0))) {
            precision = opBinding.getOperandLiteralValue(0, Integer.class);
        }
        assert (precision >= 0);
        if (precision > 3) {
            throw opBinding.newError(Static.RESOURCE.argumentMustBeValidPrecision(opBinding.getOperator().getName(), 0, 3));
        }
        return opBinding.getTypeFactory().createSqlType(this.typeName, precision);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return SqlMonotonicity.INCREASING;
    }

    @Override
    public boolean isDynamicFunction() {
        return true;
    }
}

