/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.util.TimeUnitRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlBasicCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlCase;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlFloorFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;

public class HsqldbSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new HsqldbSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HSQLDB));

    public HsqldbSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                String translatedLit = HsqldbSqlDialect.convertTimeUnit(timeUnit);
                SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, translatedLit, timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, call2, "TRUNC", true);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public SqlNode rewriteSingleValueExpr(SqlNode aggCall) {
        Object operand = ((SqlBasicCall)aggCall).operand(0);
        SqlLiteral nullLiteral = SqlLiteral.createNull(SqlParserPos.ZERO);
        SqlCall unionOperand = SqlStdOperatorTable.VALUES.createCall(SqlParserPos.ZERO, SqlLiteral.createApproxNumeric("0", SqlParserPos.ZERO));
        SqlCase caseExpr = new SqlCase(SqlParserPos.ZERO, SqlStdOperatorTable.COUNT.createCall(SqlParserPos.ZERO, new SqlNode[]{operand}), SqlNodeList.of(SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO), SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO)), SqlNodeList.of(nullLiteral, SqlStdOperatorTable.MIN.createCall(SqlParserPos.ZERO, new SqlNode[]{operand})), SqlStdOperatorTable.SCALAR_QUERY.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.UNION_ALL.createCall(SqlParserPos.ZERO, unionOperand, unionOperand)));
        LOGGER.debug("SINGLE_VALUE rewritten into [{}]", (Object)caseExpr);
        return caseExpr;
    }

    private static String convertTimeUnit(TimeUnitRange unit) {
        switch (unit) {
            case YEAR: {
                return "YYYY";
            }
            case MONTH: {
                return "MM";
            }
            case DAY: {
                return "DD";
            }
            case WEEK: {
                return "WW";
            }
            case HOUR: {
                return "HH24";
            }
            case MINUTE: {
                return "MI";
            }
            case SECOND: {
                return "SS";
            }
        }
        throw new AssertionError((Object)("could not convert time unit to HSQLDB equivalent: " + (Object)((Object)unit)));
    }
}

