/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.SchemaPlus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.TranslatableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.ViewTableMacro;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCreate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDdlNodes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.List;

public class SqlCreateView
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNodeList columnList;
    private final SqlNode query;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE VIEW", SqlKind.CREATE_VIEW);

    SqlCreateView(SqlParserPos pos, boolean replace, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        super(OPERATOR, pos, replace, false);
        this.name = Preconditions.checkNotNull(name);
        this.columnList = columnList;
        this.query = Preconditions.checkNotNull(query);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.query);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("VIEW");
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, 0, 0);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        SchemaPlus schemaPlus = ((CalciteSchema)pair.left).plus();
        for (Function function : schemaPlus.getFunctions((String)pair.right)) {
            if (!function.getParameters().isEmpty()) continue;
            if (!this.getReplace()) {
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.viewExists((String)pair.right));
            }
            ((CalciteSchema)pair.left).removeFunction((String)pair.right);
        }
        SqlNode q = SqlDdlNodes.renameColumns(this.columnList, this.query);
        String sql = q.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        ViewTableMacro viewTableMacro = ViewTable.viewMacro(schemaPlus, sql, ((CalciteSchema)pair.left).path(null), context.getObjectPath(), false);
        TranslatableTable x = viewTableMacro.apply(ImmutableList.of());
        Util.discard(x);
        schemaPlus.add((String)pair.right, viewTableMacro);
    }
}

