/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.jdbc.JdbcSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.AvaticaUtils;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.model.JsonSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.SchemaFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.SchemaPlus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCreate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDdlNodes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.NlsString;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class SqlCreateForeignSchema
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNode type;
    private final SqlNode library;
    private final SqlNodeList optionList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE FOREIGN SCHEMA", SqlKind.CREATE_FOREIGN_SCHEMA);

    SqlCreateForeignSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode type, SqlNode library, SqlNodeList optionList) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Preconditions.checkNotNull(name);
        this.type = type;
        this.library = library;
        Preconditions.checkArgument(type == null != (library == null), "of type and library, exactly one must be specified");
        this.optionList = optionList;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.type, this.library, this.optionList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("FOREIGN SCHEMA");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.library != null) {
            writer.keyword("LIBRARY");
            this.library.unparse(writer, 0, 0);
        }
        if (this.type != null) {
            writer.keyword("TYPE");
            this.type.unparse(writer, 0, 0);
        }
        if (this.optionList != null) {
            writer.keyword("OPTIONS");
            SqlWriter.Frame frame = writer.startList("(", ")");
            int i = 0;
            for (Pair<SqlIdentifier, SqlNode> c : SqlCreateForeignSchema.options(this.optionList)) {
                if (i++ > 0) {
                    writer.sep(",");
                }
                ((SqlIdentifier)c.left).unparse(writer, 0, 0);
                ((SqlNode)c.right).unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        String libraryName;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        SchemaPlus subSchema0 = ((CalciteSchema)pair.left).plus().getSubSchema((String)pair.right);
        if (subSchema0 != null && !this.getReplace() && !this.ifNotExists) {
            throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.schemaExists((String)pair.right));
        }
        if (this.type != null) {
            Preconditions.checkArgument(this.library == null);
            String typeName = (String)((Object)SqlCreateForeignSchema.value(this.type));
            JsonSchema.Type type = (JsonSchema.Type)((Object)Util.enumVal(JsonSchema.Type.class, typeName.toUpperCase(Locale.ROOT)));
            if (type != null) {
                switch (type) {
                    case JDBC: {
                        libraryName = JdbcSchema.Factory.class.getName();
                        break;
                    }
                    default: {
                        libraryName = null;
                        break;
                    }
                }
            } else {
                libraryName = null;
            }
            if (libraryName == null) {
                throw SqlUtil.newContextException(this.type.getParserPosition(), Static.RESOURCE.schemaInvalidType(typeName, Arrays.toString((Object[])JsonSchema.Type.values())));
            }
        } else {
            Preconditions.checkArgument(this.library != null);
            libraryName = (String)((Object)SqlCreateForeignSchema.value(this.library));
        }
        SchemaFactory schemaFactory = AvaticaUtils.instantiatePlugin(SchemaFactory.class, libraryName);
        LinkedHashMap<String, Object> operandMap = new LinkedHashMap<String, Object>();
        for (Pair<SqlIdentifier, SqlNode> option : SqlCreateForeignSchema.options(this.optionList)) {
            operandMap.put(((SqlIdentifier)option.left).getSimple(), SqlCreateForeignSchema.value((SqlNode)option.right));
        }
        Schema subSchema = schemaFactory.create(((CalciteSchema)pair.left).plus(), (String)pair.right, operandMap);
        ((CalciteSchema)pair.left).add((String)pair.right, subSchema);
    }

    private static Comparable value(SqlNode node) {
        Comparable v = SqlLiteral.value(node);
        return v instanceof NlsString ? ((NlsString)v).getValue() : v;
    }

    private static List<Pair<SqlIdentifier, SqlNode>> options(final SqlNodeList optionList) {
        return new AbstractList<Pair<SqlIdentifier, SqlNode>>(){

            @Override
            public Pair<SqlIdentifier, SqlNode> get(int index) {
                return Pair.of((SqlIdentifier)optionList.get(index * 2), optionList.get(index * 2 + 1));
            }

            @Override
            public int size() {
                return optionList.size() / 2;
            }
        };
    }
}

