/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ColumnStrategy;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDataTypeSpec;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.List;

public class SqlColumnDeclaration
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN_DECL", SqlKind.COLUMN_DECL);
    final SqlIdentifier name;
    final SqlDataTypeSpec dataType;
    final SqlNode expression;
    final ColumnStrategy strategy;

    SqlColumnDeclaration(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, SqlNode expression, ColumnStrategy strategy) {
        super(pos);
        this.name = name;
        this.dataType = dataType;
        this.expression = expression;
        this.strategy = strategy;
    }

    public SqlIdentifier getName() {
        return this.name;
    }

    public SqlDataTypeSpec getDataType() {
        return this.dataType;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.dataType);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, 0, 0);
        this.dataType.unparse(writer, 0, 0);
        if (this.dataType.getNullable() != null && !this.dataType.getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
        if (this.expression != null) {
            switch (this.strategy) {
                case VIRTUAL: 
                case STORED: {
                    writer.keyword("AS");
                    this.exp(writer);
                    writer.keyword(this.strategy.name());
                    break;
                }
                case DEFAULT: {
                    writer.keyword("DEFAULT");
                    this.exp(writer);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected: " + (Object)((Object)this.strategy)));
                }
            }
        }
    }

    private void exp(SqlWriter writer) {
        if (writer.isAlwaysUseParentheses()) {
            this.expression.unparse(writer, 0, 0);
        } else {
            writer.sep("(");
            this.expression.unparse(writer, 0, 0);
            writer.sep(")");
        }
    }
}

