/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlMatchRecognize;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSelectKeyword;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSelectOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import javax.annotation.Nonnull;

public class SqlSelectPipe
extends SqlCall {
    public static final int FROM_OPERAND = 2;
    public static final int WHERE_OPERAND = 3;
    public static final int HAVING_OPERAND = 5;
    SqlNodeList keywordList;
    SqlNodeList selectList;
    SqlNode from;
    SqlNode where;
    SqlNodeList groupBy;
    SqlNode having;
    SqlNodeList windowDecls;
    SqlNodeList orderBy;
    SqlNode offset;
    SqlNode fetch;
    SqlMatchRecognize matchRecognize;

    public SqlSelectPipe(SqlParserPos pos, SqlNodeList keywordList, SqlNodeList selectList, SqlNode from, SqlNode where, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNodeList orderBy, SqlNode offset, SqlNode fetch) {
        super(pos);
        this.keywordList = Preconditions.checkNotNull(keywordList != null ? keywordList : new SqlNodeList(pos));
        this.selectList = selectList;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.windowDecls = Preconditions.checkNotNull(windowDecls != null ? windowDecls : new SqlNodeList(pos));
        this.orderBy = orderBy;
        this.offset = offset;
        this.fetch = fetch;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlSelectOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.PIPE_SELECT;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.keywordList, this.selectList, this.from, this.where, this.groupBy, this.having, this.windowDecls, this.orderBy, new SqlNode[]{this.offset, this.fetch});
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywordList = Preconditions.checkNotNull((SqlNodeList)operand);
                break;
            }
            case 1: {
                this.selectList = (SqlNodeList)operand;
                break;
            }
            case 2: {
                this.from = operand;
                break;
            }
            case 3: {
                this.where = operand;
                break;
            }
            case 4: {
                this.groupBy = (SqlNodeList)operand;
                break;
            }
            case 5: {
                this.having = operand;
                break;
            }
            case 6: {
                this.windowDecls = Preconditions.checkNotNull((SqlNodeList)operand);
                break;
            }
            case 7: {
                this.orderBy = (SqlNodeList)operand;
                break;
            }
            case 8: {
                this.offset = operand;
                break;
            }
            case 9: {
                this.fetch = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final boolean isDistinct() {
        return this.getModifierNode(SqlSelectKeyword.DISTINCT) != null;
    }

    public final SqlNode getModifierNode(SqlSelectKeyword modifier) {
        for (SqlNode keyword : this.keywordList) {
            SqlSelectKeyword keyword2 = ((SqlLiteral)keyword).symbolValue(SqlSelectKeyword.class);
            if (keyword2 != modifier) continue;
            return keyword;
        }
        return null;
    }

    public final SqlNode getFrom() {
        return this.from;
    }

    public void setFrom(SqlNode from) {
        this.from = from;
    }

    public final SqlNodeList getGroup() {
        return this.groupBy;
    }

    public void setGroupBy(SqlNodeList groupBy) {
        this.groupBy = groupBy;
    }

    public final SqlNode getHaving() {
        return this.having;
    }

    public void setHaving(SqlNode having) {
        this.having = having;
    }

    public final SqlNodeList getSelectList() {
        return this.selectList;
    }

    public void setSelectList(SqlNodeList selectList) {
        this.selectList = selectList;
    }

    public final SqlNode getWhere() {
        return this.where;
    }

    public void setWhere(SqlNode whereClause) {
        this.where = whereClause;
    }

    @Nonnull
    public final SqlNodeList getWindowList() {
        return this.windowDecls;
    }

    public final SqlNodeList getOrderList() {
        return this.orderBy;
    }

    public void setOrderBy(SqlNodeList orderBy) {
        this.orderBy = orderBy;
    }

    public final SqlNode getOffset() {
        return this.offset;
    }

    public void setOffset(SqlNode offset) {
        this.offset = offset;
    }

    public final SqlNode getFetch() {
        return this.fetch;
    }

    public void setFetch(SqlNode fetch) {
        this.fetch = fetch;
    }

    public SqlMatchRecognize getMatchRecognize() {
        return this.matchRecognize;
    }

    public void setMatchRecognize(SqlMatchRecognize matchRecognize) {
        this.matchRecognize = matchRecognize;
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateQuery(this, scope, validator.getUnknownType());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() != 0;
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public boolean isKeywordPresent(SqlSelectKeyword targetKeyWord) {
        return this.getModifierNode(targetKeyWord) != null;
    }
}

