/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlAccessEnum;
import java.util.EnumSet;
import java.util.Locale;

public class SqlAccessType {
    public static final SqlAccessType ALL = new SqlAccessType(EnumSet.allOf(SqlAccessEnum.class));
    public static final SqlAccessType READ_ONLY = new SqlAccessType(EnumSet.of(SqlAccessEnum.SELECT));
    public static final SqlAccessType WRITE_ONLY = new SqlAccessType(EnumSet.of(SqlAccessEnum.INSERT));
    private final EnumSet<SqlAccessEnum> accessEnums;

    public SqlAccessType(EnumSet<SqlAccessEnum> accessEnums) {
        this.accessEnums = accessEnums;
    }

    public boolean allowsAccess(SqlAccessEnum access) {
        return this.accessEnums.contains((Object)access);
    }

    public String toString() {
        return this.accessEnums.toString();
    }

    public static SqlAccessType create(String[] accessNames) {
        assert (accessNames != null);
        EnumSet<SqlAccessEnum> enumSet = EnumSet.noneOf(SqlAccessEnum.class);
        for (String accessName : accessNames) {
            enumSet.add(SqlAccessEnum.valueOf(accessName.trim().toUpperCase(Locale.ROOT)));
        }
        return new SqlAccessType(enumSet);
    }

    public static SqlAccessType create(String accessString) {
        assert (accessString != null);
        accessString = accessString.replace('[', ' ');
        accessString = accessString.replace(']', ' ');
        String[] accessNames = accessString.split(",");
        return SqlAccessType.create(accessNames);
    }
}

