/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.BindableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptMaterialization;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.CalcitePrepareImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.Prepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.RelOptTableImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelShuttle;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableFunctionScan;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableScan;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalAggregate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalCorrelate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalExchange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalFilter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalIntersect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalJoin;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalMatch;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalMinus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalProject;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalSort;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalUnion;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.logical.LogicalValues;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schemas;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Table;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.StarTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParseException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParser;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql2rel.SqlToRelConverter;
import java.util.ArrayList;
import java.util.List;

class CalciteMaterializer
extends CalcitePrepareImpl.CalcitePreparingStmt {
    CalciteMaterializer(CalcitePrepareImpl prepare, CalcitePrepare.Context context, Prepare.CatalogReader catalogReader, CalciteSchema schema, RelOptPlanner planner, SqlRexConvertletTable convertletTable) {
        super(prepare, context, catalogReader, catalogReader.getTypeFactory(), schema, EnumerableRel.Prefer.ANY, planner, BindableConvention.INSTANCE, convertletTable);
    }

    void populate(Prepare.Materialization materialization) {
        SqlNode node;
        SqlParser parser = SqlParser.create(materialization.sql);
        try {
            node = parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(true).build();
        SqlToRelConverter sqlToRelConverter2 = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader, config);
        materialization.queryRel = sqlToRelConverter2.convertQuery((SqlNode)node, (boolean)true, (boolean)true).rel;
        this.useStar(this.schema, materialization);
        Prepare.PreparingTable table = this.catalogReader.getTable(materialization.materializedTable.path());
        materialization.tableRel = sqlToRelConverter2.toRel(table);
    }

    private void useStar(CalciteSchema schema, Prepare.Materialization materialization) {
        for (Callback x : this.useStar(schema, materialization.queryRel)) {
            materialization.materialize(x.rel, x.starRelOptTable);
            if (!CalcitePrepareImpl.DEBUG) continue;
            System.out.println("Materialization " + materialization.materializedTable + " matched star table " + x.starTable + "; query after re-write: " + RelOptUtil.toString(materialization.queryRel));
        }
    }

    private Iterable<Callback> useStar(CalciteSchema schema, RelNode queryRel) {
        List<CalciteSchema.TableEntry> starTables = Schemas.getStarTables(schema.root());
        if (starTables.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Callback> list = Lists.newArrayList();
        RelNode rel2 = RelOptMaterialization.toLeafJoinForm(queryRel);
        for (CalciteSchema.TableEntry starTable : starTables) {
            Table table = starTable.getTable();
            assert (table instanceof StarTable);
            RelOptTableImpl starRelOptTable = RelOptTableImpl.create((RelOptSchema)this.catalogReader, table.getRowType(this.typeFactory), starTable, null);
            RelNode rel3 = RelOptMaterialization.tryUseStar(rel2, starRelOptTable);
            if (rel3 == null) continue;
            list.add(new Callback(rel3, starTable, starRelOptTable));
        }
        return list;
    }

    static class Callback {
        public final RelNode rel;
        public final CalciteSchema.TableEntry starTable;
        public final RelOptTableImpl starRelOptTable;

        Callback(RelNode rel, CalciteSchema.TableEntry starTable, RelOptTableImpl starRelOptTable) {
            this.rel = rel;
            this.starTable = starTable;
            this.starRelOptTable = starRelOptTable;
        }
    }

    static class RelNullShuttle
    implements RelShuttle {
        RelNullShuttle() {
        }

        @Override
        public RelNode visit(TableScan scan) {
            return scan;
        }

        @Override
        public RelNode visit(TableFunctionScan scan) {
            return scan;
        }

        @Override
        public RelNode visit(LogicalValues values) {
            return values;
        }

        @Override
        public RelNode visit(LogicalFilter filter) {
            return filter;
        }

        @Override
        public RelNode visit(LogicalProject project) {
            return project;
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            return join;
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            return correlate;
        }

        @Override
        public RelNode visit(LogicalUnion union) {
            return union;
        }

        @Override
        public RelNode visit(LogicalIntersect intersect) {
            return intersect;
        }

        @Override
        public RelNode visit(LogicalMinus minus) {
            return minus;
        }

        @Override
        public RelNode visit(LogicalAggregate aggregate) {
            return aggregate;
        }

        @Override
        public RelNode visit(LogicalMatch match) {
            return match;
        }

        @Override
        public RelNode visit(LogicalSort sort) {
            return sort;
        }

        @Override
        public RelNode visit(LogicalExchange exchange) {
            return exchange;
        }

        @Override
        public RelNode visit(RelNode other) {
            return other;
        }
    }
}

