/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.deser.std;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.core.Base64Variants;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.DeserializationContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    private static final long serialVersionUID = 1L;
    static final int[] HEX_DIGITS;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    @Override
    protected UUID _deserialize(String id, DeserializationContext ctxt) throws IOException {
        if (id.length() != 36) {
            if (id.length() == 24) {
                byte[] stuff = Base64Variants.getDefaultVariant().decode(id);
                return this._fromBytes(stuff, ctxt);
            }
            this._badFormat(id);
        }
        if (id.charAt(8) != '-' || id.charAt(13) != '-' || id.charAt(18) != '-' || id.charAt(23) != '-') {
            this._badFormat(id);
        }
        long l1 = UUIDDeserializer.intFromChars(id, 0);
        long l2 = (long)UUIDDeserializer.shortFromChars(id, 9) << 16;
        long hi = (l1 <<= 32) + (l2 |= (long)UUIDDeserializer.shortFromChars(id, 14));
        int i1 = UUIDDeserializer.shortFromChars(id, 19) << 16 | UUIDDeserializer.shortFromChars(id, 24);
        l1 = i1;
        l2 = UUIDDeserializer.intFromChars(id, 28);
        l2 = l2 << 32 >>> 32;
        long lo = (l1 <<= 32) | l2;
        return new UUID(hi, lo);
    }

    @Override
    protected UUID _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws IOException {
        if (ob instanceof byte[]) {
            return this._fromBytes((byte[])ob, ctxt);
        }
        super._deserializeEmbedded(ob, ctxt);
        return null;
    }

    private void _badFormat(String uuidStr) {
        throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
    }

    static int intFromChars(String str, int index) {
        return (UUIDDeserializer.byteFromChars(str, index) << 24) + (UUIDDeserializer.byteFromChars(str, index + 2) << 16) + (UUIDDeserializer.byteFromChars(str, index + 4) << 8) + UUIDDeserializer.byteFromChars(str, index + 6);
    }

    static int shortFromChars(String str, int index) {
        return (UUIDDeserializer.byteFromChars(str, index) << 8) + UUIDDeserializer.byteFromChars(str, index + 2);
    }

    static int byteFromChars(String str, int index) {
        int hex;
        char c1 = str.charAt(index);
        char c2 = str.charAt(index + 1);
        if (c1 <= '\u007f' && c2 <= '\u007f' && (hex = HEX_DIGITS[c1] << 4 | HEX_DIGITS[c2]) >= 0) {
            return hex;
        }
        if (c1 > '\u007f' || HEX_DIGITS[c1] < 0) {
            return UUIDDeserializer._badChar(str, index, c1);
        }
        return UUIDDeserializer._badChar(str, index + 1, c2);
    }

    static int _badChar(String uuidStr, int index, char c) {
        throw new NumberFormatException("Non-hex character '" + c + "', not valid character for a UUID String" + "' (value 0x" + Integer.toHexString(c) + ") for UUID String \"" + uuidStr + "\"");
    }

    private UUID _fromBytes(byte[] bytes, DeserializationContext ctxt) throws IOException {
        if (bytes.length != 16) {
            ctxt.mappingException("Can only construct UUIDs from byte[16]; got %d bytes", bytes.length);
        }
        return new UUID(UUIDDeserializer._long(bytes, 0), UUIDDeserializer._long(bytes, 8));
    }

    private static long _long(byte[] b, int offset) {
        long l1 = (long)UUIDDeserializer._int(b, offset) << 32;
        long l2 = UUIDDeserializer._int(b, offset + 4);
        l2 = l2 << 32 >>> 32;
        return l1 | l2;
    }

    private static int _int(byte[] b, int offset) {
        return b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    static {
        int i;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (i = 0; i < 10; ++i) {
            UUIDDeserializer.HEX_DIGITS[48 + i] = i;
        }
        for (i = 0; i < 6; ++i) {
            UUIDDeserializer.HEX_DIGITS[97 + i] = 10 + i;
            UUIDDeserializer.HEX_DIGITS[65 + i] = 10 + i;
        }
    }
}

