/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.DataContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.JaninoFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.Helper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.InterpretableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.InterpretableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Interpreter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.JaninoRexCompiler;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Node;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Row;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Sink;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.AbstractEnumerable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.ClassDeclaration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.ConventionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.CalcitePrepareImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.convert.ConverterImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.SofaClassLoaderWrapper;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.ArrayBindable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.Bindable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.Hook;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.Typed;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.Utilities;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.CompileException;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.IClassBodyEvaluator;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.ICompilerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EnumerableInterpretable
extends ConverterImpl
implements InterpretableRel {
    private static Lock selectAllLock = new ReentrantLock();
    private static ConcurrentHashMap<String, Set<String>> selectAllSql = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Bindable> bindableMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Lock> bindableLockMap = new ConcurrentHashMap();
    private static ThreadLocal<String> curSqlResource = new ThreadLocal();

    protected EnumerableInterpretable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), input);
    }

    public static Lock getLock() {
        String curSql = curSqlResource.get();
        if (curSql == null) {
            throw new RuntimeException("curSql is null");
        }
        Lock retLock = bindableLockMap.get(curSql);
        if (retLock == null) {
            ReentrantLock tmp = new ReentrantLock();
            Lock ai = bindableLockMap.putIfAbsent(curSql, tmp);
            retLock = ai == null ? tmp : ai;
        }
        return retLock;
    }

    private static String genNameSpaceAndTableName(String nameSpace, String tableName) {
        return nameSpace + "." + tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putSelectAllSql(String nameSpace, String tableName, String sql) {
        try {
            selectAllLock.lock();
            String nameSpaceAndTableName = EnumerableInterpretable.genNameSpaceAndTableName(nameSpace, tableName);
            Set<String> retSet = selectAllSql.get(nameSpaceAndTableName);
            if (retSet == null) {
                HashSet<String> tmpList = new HashSet<String>();
                Set<String> tmpRet = selectAllSql.putIfAbsent(nameSpaceAndTableName, tmpList);
                retSet = tmpRet == null ? tmpList : tmpRet;
            }
            retSet.add(sql);
        }
        finally {
            selectAllLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentHashMap<String, Set<String>> getSelectAllSql(String nameSpace, String tableName) {
        try {
            selectAllLock.lock();
            ConcurrentHashMap<String, Set<String>> tmp = new ConcurrentHashMap<String, Set<String>>();
            tmp.putAll(selectAllSql);
            ConcurrentHashMap<String, Set<String>> concurrentHashMap = tmp;
            return concurrentHashMap;
        }
        finally {
            selectAllLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBindableForTable(String nameSpace, String tableName) {
        try {
            selectAllLock.lock();
            String nameSpaceAndTableName = EnumerableInterpretable.genNameSpaceAndTableName(nameSpace, tableName);
            Set<String> retSet = selectAllSql.remove(nameSpaceAndTableName);
            if (retSet != null) {
                for (String sql : retSet) {
                    bindableMap.remove(sql);
                }
            }
        }
        finally {
            selectAllLock.unlock();
        }
    }

    public static void setCurSql(String curSql) {
        curSqlResource.set(curSql);
    }

    public static ConcurrentHashMap<String, Bindable> getBindableMap() {
        return bindableMap;
    }

    public static Bindable getBinable() {
        String curSql = curSqlResource.get();
        if (curSql == null) {
            throw new RuntimeException("curSql is null");
        }
        return bindableMap.get(curSql);
    }

    public static void addBinable(Bindable bindable) {
        String curSql = curSqlResource.get();
        if (curSql == null) {
            throw new RuntimeException("curSql is null");
        }
        bindableMap.putIfAbsent(curSql, bindable);
    }

    @Override
    public EnumerableInterpretable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpretable(this.getCluster(), EnumerableInterpretable.sole(inputs));
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        Bindable bindable = EnumerableInterpretable.toBindable(implementor.internalParameters, implementor.spark, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        Enumerable<Object[]> enumerable = arrayBindable.bind(implementor.dataContext);
        return new EnumerableNode(enumerable, implementor.interpreter, this);
    }

    public static Bindable toBindable(Map<String, Object> parameters, CalcitePrepare.SparkHandler spark, EnumerableRel rel, EnumerableRel.Prefer prefer) {
        String s = null;
        Lock lock = EnumerableInterpretable.getLock();
        try {
            lock.lock();
            Bindable ret = EnumerableInterpretable.getBinable();
            if (ret != null) {
                Bindable bindable = ret;
                return bindable;
            }
            EnumerableRelImplementor relImplementor = new EnumerableRelImplementor(rel.getCluster().getRexBuilder(), parameters);
            ClassDeclaration expr = relImplementor.implementRoot(rel, prefer);
            s = Expressions.toString(expr.memberDeclarations, "\n", false);
            if (CalcitePrepareImpl.DEBUG) {
                Util.debugCode(System.out, s);
            }
            Hook.JAVA_PLAN.run(s);
            if (spark != null && spark.enabled()) {
                ArrayBindable arrayBindable = spark.compile(expr, s);
                return arrayBindable;
            }
            Bindable gen = EnumerableInterpretable.getBindable(expr, s, rel.getRowType().getFieldCount());
            EnumerableInterpretable.addBinable(gen);
            Bindable bindable = gen;
            return bindable;
        }
        catch (Exception e) {
            throw Helper.INSTANCE.wrap("Error while compiling generated Java code:\n" + s, e);
        }
        finally {
            lock.unlock();
        }
    }

    static ArrayBindable getArrayBindable(ClassDeclaration expr, String s, int fieldCount) throws CompileException, IOException {
        Bindable bindable = EnumerableInterpretable.getBindable(expr, s, fieldCount);
        return EnumerableInterpretable.box(bindable);
    }

    static Bindable getBindable(ClassDeclaration expr, String s, int fieldCount) throws CompileException, IOException {
        Class[] classArray;
        ICompilerFactory compilerFactory;
        try {
            compilerFactory = JaninoFactory.getDefaultJaninoFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setExtendedClass(Utilities.class);
        if (fieldCount == 1) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Bindable.class;
            classArray = classArray2;
            classArray2[1] = Typed.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = ArrayBindable.class;
        }
        cbe.setImplementedInterfaces(classArray);
        ClassLoader appClassLoader = JaninoRexCompiler.class.getClassLoader();
        SofaClassLoaderWrapper sofaClassLoaderWrapper = new SofaClassLoaderWrapper(appClassLoader);
        cbe.setParentClassLoader(sofaClassLoaderWrapper);
        if (CalcitePrepareImpl.DEBUG) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Bindable)cbe.createInstance(new StringReader(s));
    }

    static ArrayBindable box(final Bindable bindable) {
        if (bindable instanceof ArrayBindable) {
            return (ArrayBindable)bindable;
        }
        return new ArrayBindable(){

            @Override
            public Class<Object[]> getElementType() {
                return Object[].class;
            }

            @Override
            public Enumerable<Object[]> bind(DataContext dataContext) {
                final Enumerable enumerable = bindable.bind(dataContext);
                return new AbstractEnumerable<Object[]>(){

                    @Override
                    public Enumerator<Object[]> enumerator() {
                        final Enumerator enumerator = enumerable.enumerator();
                        return new Enumerator<Object[]>(){

                            @Override
                            public Object[] current() {
                                return new Object[]{enumerator.current()};
                            }

                            @Override
                            public boolean moveNext() {
                                return enumerator.moveNext();
                            }

                            @Override
                            public void reset() {
                                enumerator.reset();
                            }

                            @Override
                            public void close() {
                                enumerator.close();
                            }
                        };
                    }
                };
            }
        };
    }

    private static class EnumerableNode
    implements Node {
        private final Enumerable<Object[]> enumerable;
        private final Sink sink;

        EnumerableNode(Enumerable<Object[]> enumerable, Interpreter interpreter, EnumerableInterpretable rel) {
            this.enumerable = enumerable;
            this.sink = interpreter.sink(rel);
        }

        @Override
        public void run() throws InterruptedException {
            Enumerator enumerator = this.enumerable.enumerator();
            while (enumerator.moveNext()) {
                Object[] values = (Object[])enumerator.current();
                this.sink.send(Row.of(values));
            }
        }
    }
}

