/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.elasticsearch.MapProjectionFieldVisitor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelFieldCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Sort;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ElasticsearchSort
extends Sort
implements ElasticsearchRel {
    public ElasticsearchSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode relNode, RelCollation relCollation, RexNode offset, RexNode fetch) {
        return new ElasticsearchSort(this.getCluster(), traitSet, relNode, this.collation, offset, fetch);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (!this.collation.getFieldCollations().isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>();
            if (this.input instanceof Project) {
                List<RexNode> projects = ((Project)this.input).getProjects();
                for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                    RexNode project = projects.get(fieldCollation.getFieldIndex());
                    String name = project.accept(MapProjectionFieldVisitor.INSTANCE);
                    keys.add(ElasticsearchRules.quote(name) + ": " + this.direction(fieldCollation));
                }
            } else {
                List<RelDataTypeField> fields = this.getRowType().getFieldList();
                for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                    String name = fields.get(fieldCollation.getFieldIndex()).getName();
                    keys.add(ElasticsearchRules.quote(name) + ": " + this.direction(fieldCollation));
                }
            }
            implementor.add("\"sort\": [ " + Util.toString(keys, "{", "}, {", "}") + "]");
        }
        if (this.offset != null) {
            implementor.add("\"from\": " + ((RexLiteral)this.offset).getValue());
        }
        if (this.fetch != null) {
            implementor.add("\"size\": " + ((RexLiteral)this.fetch).getValue());
        }
    }

    private String direction(RelFieldCollation fieldCollation) {
        switch (fieldCollation.getDirection()) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return "\"desc\"";
            }
        }
        return "\"asc\"";
    }
}

