/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WSingleColumnTimestampFilter
extends WFilter {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    protected long ts = 0L;
    private WByteArrayComparable comparator;
    private boolean filterIfMissing = true;
    private boolean latestVersionOnly = true;

    public WSingleColumnTimestampFilter() {
    }

    public WSingleColumnTimestampFilter(byte[] family, byte[] qualifier, long ts, byte[] value) {
        this(family, qualifier, ts, new WBinaryComparator(value));
    }

    public WSingleColumnTimestampFilter(byte[] family, byte[] qualifier, long ts, WByteArrayComparable comparator) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.comparator = comparator;
        this.ts = ts;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(byte[] columnFamily) {
        this.columnFamily = columnFamily;
    }

    public byte[] getColumnQualifier() {
        return this.columnQualifier;
    }

    public void setColumnQualifier(byte[] columnQualifier) {
        this.columnQualifier = columnQualifier;
    }

    public long getTs() {
        return this.ts;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public WByteArrayComparable getComparator() {
        return this.comparator;
    }

    public void setComparator(WByteArrayComparable comparator) {
        this.comparator = comparator;
    }

    public boolean isFilterIfMissing() {
        return this.filterIfMissing;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        WByteArrayComparable.write(out, this.comparator);
        out.writeBoolean(this.filterIfMissing);
        out.writeBoolean(this.latestVersionOnly);
        out.writeLong(this.ts);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnFamily = Bytes.readByteArray(in);
        if (this.columnFamily.length == 0) {
            this.columnFamily = null;
        }
        this.columnQualifier = Bytes.readByteArray(in);
        if (this.columnQualifier.length == 0) {
            this.columnQualifier = null;
        }
        this.comparator = WByteArrayComparable.read(in);
        this.filterIfMissing = in.readBoolean();
        this.latestVersionOnly = in.readBoolean();
        this.ts = in.readLong();
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WSingleColumnTimestampFilter;
    }
}

