/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.BasicDDLService;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.PrimaryKeyValueAccessor;
import com.alibaba.lindorm.client.core.meta.RangeRouter;
import com.alibaba.lindorm.client.core.meta.SilenceIndex;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableMetaChangeEventHandler;
import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.types.LAccDouble;
import com.alibaba.lindorm.client.core.types.LAccLong;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LEncodedVarbinary;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.Mutability;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaUtils {
    public static final Log LOG = LogFactory.getLog(SchemaUtils.class);
    public static final String MAX_PK_COLUMN_LENGTH_KEY = "lindorm.schema.column.pklength.max";
    public static final int DEFAULT_MAX_PK_COLUMN_LENGTH = 2048;
    public static final String MAX_NONPK_COLUMN_LENGTH_KEY = "lindorm.schema.column.nonpklength.max";
    public static final int DEFAULT_MAX_NONPK_COLUMN_LENGTH = 0x200000;
    public static final byte SEPARATOR_BYTE = 0;
    public static final byte[] SEPARATOR_BYTES = new byte[]{0};
    public static final byte SEPARATOR_BYTE_DESC = DataTypeUtils.invert((byte)0);
    public static final byte[] SEPARATOR_BYTES_DESC = new byte[]{SEPARATOR_BYTE_DESC};
    public static final String PK_HASHED = "PK_HASHED";
    public static final byte[] DEFAULT_PK_HASHED = Bytes.toBytes(false);
    public static final String STORE_PK_NULLS = "STORE_PK_NULLS";
    public static final byte[] DEFAULT_STORE_PK_NULLS = Bytes.toBytes(false);
    public static final byte VALUE_PREFIX_BYTE = 1;
    public static final byte[] VALUE_PREFIX_BYTES = new byte[]{1};
    public static final byte NULL_VALUE_PREFIX_BYTE = 0;
    public static final byte[] NULL_VALUE_PREFIX_BYTES = new byte[]{0};
    public static String COLUMN_NAME_SEPARATOR = ":";
    public static byte[] COLUMN_NAME_SEPARATOR_BYTES = Bytes.toBytes(COLUMN_NAME_SEPARATOR);
    public static final String DEFAULT_FAMILY_NAME = "f";
    public static final byte[] DEFAULT_FAMILY_NAME_BYTES = Bytes.toBytes("f");
    public static final String DEFAULT_LOCAL_INDEX_FAMILY_NAME = "lf";
    public static final byte[] DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES = Bytes.toBytes("lf");
    public static final ColumnFamilyDescriptor DEFAULT_LOCAL_INDEX_CFD = new ColumnFamilyDescriptor(DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES);
    public static final String DEFAULT_COLUMN_NAME = "0";
    public static final byte[] DEFAULT_COLUMN_NAME_BYTES = Bytes.toBytes("0");
    public static final LColumn DEFAULT_COLUMN_META = LColumn.createDefaultColumnMeta();
    public static final LColumn DEFAULT_LOCAL_INDEX_COLUMN_META = LColumn.createDefaultLocalIndexColumnMeta();
    public static final byte[] DEFAULT_EMPTY_BYTE_ARRAY = new byte[0];
    public static final int MAX_VERSION_FOR_INDEX = 1;
    public static final int MAX_ATTRIBUTE_COMMENTS_SIZE = 256;
    public static final String TABLE_META_ATTR_KEY = "_META_KEY_";

    public static final byte[] getValuePrefixBytes(SortOrder sortOrder) {
        return sortOrder == SortOrder.ASC ? VALUE_PREFIX_BYTES : NULL_VALUE_PREFIX_BYTES;
    }

    public static final byte[] getNullValuePrefixBytes(SortOrder sortOrder) {
        return sortOrder == SortOrder.ASC ? NULL_VALUE_PREFIX_BYTES : VALUE_PREFIX_BYTES;
    }

    public static boolean isNullValueByte(byte b, SortOrder sortOrder) {
        if (sortOrder == SortOrder.ASC) {
            return b == 0;
        }
        return b == 1;
    }

    public static boolean isNullValueBytes(LColumn column, byte[] bytes, SortOrder sortOrder) {
        return SchemaUtils.storePkNulls(column) && Bytes.compareTo(bytes, SchemaUtils.getNullValuePrefixBytes(sortOrder)) == 0;
    }

    public static boolean storePkNulls(LColumn column) {
        return column.getDataColumnKey() != null && column.isStoreNull();
    }

    public static LColumn getDefaultColumnMeta(TableMeta tableMeta) {
        if (tableMeta.isLocalIndex()) {
            return DEFAULT_LOCAL_INDEX_COLUMN_META;
        }
        return DEFAULT_COLUMN_META;
    }

    public static byte getSeparatorByte(SortOrder sortOrder) {
        if (sortOrder == SortOrder.ASC) {
            return 0;
        }
        return SEPARATOR_BYTE_DESC;
    }

    public static byte[] getSeparatorBytes(SortOrder sortOrder) {
        if (sortOrder == SortOrder.ASC) {
            return SEPARATOR_BYTES;
        }
        return SEPARATOR_BYTES_DESC;
    }

    public static boolean isSeparatorByte(byte b) {
        return b == 0 || b == SEPARATOR_BYTE_DESC;
    }

    public static boolean hasSeparatorByte(LDataType type) {
        return !type.isFixedWidth() && type != LVarbinary.INSTANCE && type != LEncodedVarbinary.INSTANCE;
    }

    public static boolean isDefaultFamily(byte[] familyName) {
        return Bytes.compareTo(DEFAULT_FAMILY_NAME_BYTES, familyName) == 0 || Bytes.compareTo(DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES, familyName) == 0;
    }

    public static boolean isDefaultFamily(byte[] buf, int offset, int length) {
        return Bytes.compareTo(DEFAULT_FAMILY_NAME_BYTES, 0, DEFAULT_FAMILY_NAME_BYTES.length, buf, offset, length) == 0 || Bytes.compareTo(DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES, 0, DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES.length, buf, offset, length) == 0;
    }

    public static boolean isDefaultColumn(byte[] qualifier) {
        return Bytes.compareTo(DEFAULT_COLUMN_NAME_BYTES, qualifier) == 0;
    }

    public static boolean isDefaultColumn(byte[] qualifier, int offset, int length) {
        return Bytes.compareTo(DEFAULT_COLUMN_NAME_BYTES, 0, DEFAULT_COLUMN_NAME_BYTES.length, qualifier, offset, length) == 0;
    }

    public static boolean isDefaultColumnKey(ColumnKey columnKey) {
        return DEFAULT_COLUMN_META.getColumnKey().equals(columnKey) || DEFAULT_LOCAL_INDEX_COLUMN_META.getColumnKey().equals(columnKey);
    }

    public static void validateTimestamp(long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp must be positive or zero, but has " + ts);
        }
    }

    public static void validateTableName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Table name must not be empty, please check your table descriptor and retry.");
        }
        byte[] tableName = Bytes.toBytes(name);
        if (tableName == null) {
            throw new IllegalArgumentException("Illegal table name, failed converting to UTF-8 byte array: " + name);
        }
        if (tableName[0] == 46 || tableName[0] == 45) {
            throw new IllegalArgumentException("Illegal first character <" + tableName[0] + "> at 0. User-space table names can only start with 'word " + "characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(tableName));
        }
        for (int i = 0; i < tableName.length; ++i) {
            if (Character.isLetterOrDigit(tableName[i]) || tableName[i] == 95 || tableName[i] == 45) continue;
            throw new IllegalArgumentException("Illegal character <" + tableName[i] + "> at " + i + ". User-space table names can only contain " + "'word characters': i.e. [a-zA-Z_0-9-.]: " + Bytes.toString(tableName));
        }
    }

    public static void validateFamilyName(String name) {
    }

    public static void validateTableDescriptor(LindormTableDescriptor desc) throws LindormException {
        SchemaUtils.validateTableName(desc.getName());
        if (desc.getPkColumns() == null || desc.getPkColumns().size() == 0) {
            throw new LindormException("Cannot find primary key schema, there must be at least one PK column.");
        }
        if (desc.getNonPkColumns() == null || desc.getNonPkColumns().size() == 0) {
            throw new LindormException("Cannot find non-PK schema, there must be at least one non-PK column.");
        }
        List<PrimaryKeySchema> pkSchema = desc.getPkColumns();
        for (int i = 0; i < pkSchema.size(); ++i) {
            PrimaryKeySchema pk = pkSchema.get(i);
            if (pk.getDataType() == DataType.VARBINARY) {
                if (i != pkSchema.size() - 1) {
                    throw new LindormException("Primary key column " + Bytes.toString(pk.getName()) + " of VARBINARY data type must be the last pk column," + " but now found at position " + i + "(zero-based). " + "If you want VARBINARY type at an arbitrary position, please use ENCODED_VARBINARY type instead.");
                }
                if (SortOrder.DESC.equals((Object)pk.getSortOrder())) {
                    throw new LindormException("Unsupported DESC order for VARBINARY type for PK column " + Bytes.toString(pk.getName()) + ", please use ENCODED_VARBINARY if you need DESC order.");
                }
            }
            if (!pk.isHashed() || i <= 0) continue;
            throw new LindormException("Only the first primary key is hash key, current primary key is:" + pk);
        }
        SchemaUtils.validateColumnSchema(desc);
        FeedStreamUtils.validateSystemFamilyProperty(desc);
    }

    public static void checkNullOrEmpty(String toCheck, String msgPrefix) throws IllegalRequestException {
        if (toCheck == null || toCheck.isEmpty()) {
            throw new IllegalRequestException(msgPrefix + " must not be null or empty.");
        }
    }

    public static <T> void checkNullOrEmpty(List<T> toCheck, String msgPrefix) throws IllegalRequestException {
        if (toCheck == null || toCheck.isEmpty()) {
            throw new IllegalRequestException(msgPrefix + " must not be null or empty.");
        }
    }

    public static void checkCreateIndexCondition(TableMeta dataTableMeta, LindormIndexDescriptor indexDescriptor) throws LindormException {
        Condition indexCondition = indexDescriptor.getIndexCondition();
        if (indexCondition == null) {
            return;
        }
        SchemaUtils.validateIndexComparisionExpression(dataTableMeta, indexDescriptor, indexCondition);
    }

    private static void validateIndexComparisionExpression(TableMeta dataTableMeta, LindormIndexDescriptor indexDescriptor, Condition indexCondition) throws LindormException {
        if (indexCondition instanceof ConditionList) {
            List<Condition> conditions = ((ConditionList)indexCondition).getConditions();
            for (Condition c : conditions) {
                SchemaUtils.validateIndexComparisionExpression(dataTableMeta, indexDescriptor, c);
            }
            return;
        }
        if (!(indexCondition instanceof ComparisonExpression)) {
            return;
        }
        ComparisonExpression ce = (ComparisonExpression)indexCondition;
        List<IndexedColumnSchema> indexedColumns = indexDescriptor.getIndexedColumns();
        ColumnKey ck = ce.getColumnKey();
        LColumn lc = dataTableMeta.resolveColumn(ck);
        if (lc.isPrimaryKey()) {
            throw new LindormException("Index conditions that contain primary keys are not supported: " + ck);
        }
        boolean hit = false;
        for (IndexedColumnSchema ics : indexedColumns) {
            if (!ics.getColumnKey().equals(ck)) continue;
            hit = true;
            break;
        }
        if (!hit) {
            throw new LindormException("Index conditions can only contain index columns: " + ck);
        }
        ce.evaluateRHS(lc);
    }

    public static void checkMeaninglessIndex(TableMeta dataTableMeta, LindormIndexDescriptor indexDescriptor) throws LindormException {
        List<IndexedColumnSchema> indexedColumns = indexDescriptor.getIndexedColumns();
        ArrayList<Object> tableMetas = dataTableMeta.hasIndex() ? new ArrayList<TableMeta>(dataTableMeta.getIndexMetas().values()) : CollectionUtils.newArrayList();
        tableMetas.add(dataTableMeta);
        for (TableMeta tableMeta : tableMetas) {
            boolean repeated = true;
            List<LColumn> pkColumns = tableMeta.getPkColumns();
            if (indexedColumns.size() > pkColumns.size()) {
                repeated = false;
            } else {
                int i = -1;
                while (++i < indexedColumns.size()) {
                    IndexedColumnSchema indexedColumnSchema = indexedColumns.get(i);
                    LColumn lColumn = tableMeta.resolveColumnNoThrow(indexedColumnSchema.getColumnKey());
                    if (null == lColumn) {
                        repeated = false;
                        break;
                    }
                    LColumn pkColumn = pkColumns.get(i);
                    if (lColumn.getColumnKey().equals(pkColumn.getColumnKey()) && pkColumn.getSortOrder() == indexedColumnSchema.getSortOrder()) continue;
                    repeated = false;
                }
            }
            if (!repeated) continue;
            throw new LindormException(indexDescriptor.getIndexName() + " is repeated with " + tableMeta.getTableName() + ", primary key =" + pkColumns + ".");
        }
    }

    @Deprecated
    public static void checkMaxVersion(LColumn lColumn, TableMeta tableMeta) throws LindormException {
        if (lColumn.isPrimaryKey()) {
            return;
        }
        for (ColumnFamilyDescriptor cf : tableMeta.getFamilies()) {
            if (!Bytes.equals(cf.getName(), lColumn.getFamilyName())) continue;
            if (cf.getMaxVersions() != 1) {
                throw new LindormException("The value of max version [" + cf.getMaxVersions() + "] is not equal to " + 1);
            }
            return;
        }
        if (tableMeta.getFamilyAttributes().getMaxVersions() != 1) {
            throw new LindormException("The default value of max version [" + tableMeta.getFamilyAttributes().getMaxVersions() + "] is not equal to " + 1);
        }
    }

    public static void validateMaxVersionWithIndex(TableMeta dataTableMeta) throws LindormException {
        ArrayList<TableMeta> tableToCheck;
        if (dataTableMeta.hasIndex()) {
            tableToCheck = new ArrayList(1 + dataTableMeta.getIndexLogicalNames().size());
            tableToCheck.addAll(dataTableMeta.getIndexMetas().values());
        } else {
            tableToCheck = new ArrayList<TableMeta>(1);
        }
        tableToCheck.add(dataTableMeta);
        for (TableMeta table : tableToCheck) {
            Integer maxVersion = table.getFamilyAttributes().getMaxVersionsNoDefault();
            if (maxVersion != null && maxVersion != 1) {
                throw new IllegalRequestException("MaxVersion must be 1 for table with index, but has " + maxVersion + ", tableName=" + table.getTableName());
            }
            for (ColumnFamilyDescriptor desc : table.getFamilies()) {
                maxVersion = desc.getFamilyAttributes().getMaxVersionsNoDefault();
                if (maxVersion == null || maxVersion == 1) continue;
                throw new IllegalRequestException("MaxVersion must be 1 for table with index, but has " + maxVersion + ", tableName=" + table.getTableName() + ", familyName=" + desc.getNameAsString());
            }
        }
    }

    public static void checkTTL(TableMeta tableMeta) throws LindormException {
        if (tableMeta.getFamilies().size() == 1) {
            return;
        }
        Integer tableTTL = tableMeta.getFamilyAttributes().getTimeToLive();
        Integer preTTL = null;
        String preFamilyName = null;
        for (ColumnFamilyDescriptor cf : tableMeta.getFamilies()) {
            Integer cfTTL = cf.getFamilyAttributes().getTimeToLiveNoDefault();
            if (cfTTL == null) {
                cfTTL = tableTTL;
            }
            if (preTTL != null && !preTTL.equals(cfTTL)) {
                throw new LindormException("The TTL of all family must be the same. family:" + preFamilyName + " ttl: " + preTTL + ", " + "family:" + cf.getNameAsString() + " ttl:" + cfTTL);
            }
            preTTL = cfTTL;
            preFamilyName = cf.getNameAsString();
        }
    }

    @Deprecated
    public static void validateIndexBasedOnDataTable(TableMeta dataTableMeta, LindormIndexDescriptor indexDescriptor) throws LindormException {
        String indexName;
        LColumn lColumn;
        if (dataTableMeta.hasIndex() && dataTableMeta.getIndexLogicalNames().size() >= 5) {
            throw new IllegalRequestException("Cannot create index " + indexDescriptor.getIndexName() + " on an index table " + dataTableMeta.getTableName() + ", the number of indexes has exceeded the maximum:" + 5);
        }
        if (TableType.DATA_TABLE != dataTableMeta.getType()) {
            throw new IllegalRequestException("Cannot create index " + indexDescriptor.getIndexName() + " on an index table " + dataTableMeta.getTableName());
        }
        Mutability dataTableMutability = dataTableMeta.getTableAttributes().getMutabilityNoDefault();
        if (dataTableMutability == null) {
            throw new IllegalRequestException("Mutability on data table [" + dataTableMeta.getTableName() + "] not set, please set it explicitly before creating indexes on it.");
        }
        if (dataTableMutability != Mutability.IMMUTABLE && dataTableMeta.getConsistencyType() != TableAttributes.ConsistencyType.Strong) {
            throw new IllegalRequestException("Data table " + dataTableMeta.getTableName() + " must have [strong] consistency type, but has [" + (Object)((Object)dataTableMeta.getConsistencyType()) + "]");
        }
        List<ColumnKey> coveredColumns = indexDescriptor.getCoveredColumns();
        if (!coveredColumns.isEmpty() && coveredColumns.get(0) == LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA && null != (lColumn = dataTableMeta.resolveColumnNoThrow(DEFAULT_COLUMN_META.getColumnKey()))) {
            throw new LindormException("Cannot covered all columns in schema of data table " + dataTableMeta.getTableName() + ", because of it has default column key [" + SchemaUtils.getFullColumnName(DEFAULT_FAMILY_NAME_BYTES, DEFAULT_COLUMN_NAME_BYTES) + "].");
        }
        if (!coveredColumns.isEmpty()) {
            for (ColumnKey ck : coveredColumns) {
                LColumn column = dataTableMeta.resolveColumnNoThrow(ck);
                if (null == column || !column.isPrimaryKey()) continue;
                throw new LindormException("Cannot covered primary key:" + ck + " of data table.");
            }
        }
        if (null != dataTableMeta.getIndexMeta(indexName = indexDescriptor.getIndexName())) {
            throw new LindormException("Index exists:" + indexName);
        }
        SchemaUtils.checkTTL(dataTableMeta);
        SchemaUtils.validateMaxVersionWithIndex(dataTableMeta);
        SchemaUtils.checkMeaninglessIndex(dataTableMeta, indexDescriptor);
        SchemaUtils.checkCreateIndexCondition(dataTableMeta, indexDescriptor);
    }

    public static void validateIndexTableDescriptor(LindormIndexDescriptor desc) throws LindormException {
        if (null == desc) {
            throw new IllegalRequestException("Index descriptor must not be null.");
        }
        SchemaUtils.validateTableName(desc.getIndexName());
        SchemaUtils.validateTableName(desc.getDataTableName());
        List<IndexedColumnSchema> indexedColumns = desc.getIndexedColumns();
        if (indexedColumns == null || indexedColumns.size() == 0) {
            throw new IllegalRequestException("There must be at least one indexed column, but has none. IndexName=" + desc.getIndexName());
        }
        int i = 0;
        HashSet<ColumnKey> columns = CollectionUtils.newHashSet();
        for (IndexedColumnSchema ic : indexedColumns) {
            if (Bytes.compareTo(ic.getColumnKey().getQualifier(), DEFAULT_COLUMN_NAME_BYTES) == 0) {
                throw new IllegalRequestException("Column name [0] is reserved, please use another name.");
            }
            if (columns.contains(ic.getColumnKey())) {
                throw new IllegalRequestException("Duplicate indexed column " + ic.getColumnKey().toString() + ", please check your DDL and retry.");
            }
            columns.add(ic.getColumnKey());
            if (!ic.isHashed()) continue;
            if (i > 0) {
                throw new LindormException("Only the first index column key is hash key:" + indexedColumns);
            }
            ++i;
        }
        List<ColumnKey> coveredColumns = desc.getCoveredColumns();
        if (coveredColumns != null && coveredColumns.size() > 0) {
            for (ColumnKey ck : coveredColumns) {
                if (SchemaUtils.isDefaultColumnKey(ck)) {
                    throw new IllegalRequestException("Covered columns of index name " + desc.getIndexName() + " are illegal, default column key [" + SchemaUtils.getFullColumnName(DEFAULT_FAMILY_NAME_BYTES, DEFAULT_COLUMN_NAME_BYTES) + "] is reserved.");
                }
                if (ck.getFamily() == null && SchemaUtils.isDefaultColumn(ck.getQualifier())) {
                    throw new IllegalRequestException("Covered columns of index name " + desc.getIndexName() + " are illegal, default column name [" + DEFAULT_COLUMN_NAME + "] is reserved.");
                }
                if ((ck == LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA || ck == LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS) && coveredColumns.size() > 1) {
                    throw new IllegalRequestException("Especial covered columns and user specified covered columns cannot coexist together.");
                }
                if (columns.contains(ck)) {
                    throw new IllegalRequestException("Duplicate indexed column " + ck.toString() + ", please check your DDL and retry.");
                }
                columns.add(ck);
            }
        }
    }

    public static void validateColumnSchema(LindormTableDescriptor desc) throws LindormException {
        Comparable<PrimaryKeySchema> existed;
        TreeMap<byte[], Comparable<PrimaryKeySchema>> columns = new TreeMap<byte[], Comparable<PrimaryKeySchema>>(Bytes.BYTES_COMPARATOR);
        for (PrimaryKeySchema pk : desc.getPkColumns()) {
            existed = columns.put(pk.getName(), pk);
            if (existed == null) continue;
            throw new IllegalDataException("Detect duplicate column " + pk.toString());
        }
        for (ColumnSchema col : desc.getNonPkColumns()) {
            existed = columns.put(SchemaUtils.getFullColumnNameBytes(col.getFamilyName(), col.getColumnName()), col);
            if (existed != null) {
                throw new IllegalDataException("Detect duplicate column " + col.toString());
            }
            if (col.getFamilyName() == null) continue;
            existed = columns.put(col.getColumnName(), col);
            if (existed != null) {
                throw new IllegalDataException("Detect duplicate column " + col.toString() + ", already has " + existed.toString());
            }
            if (desc.hasFamily(col.getFamilyName())) continue;
            throw new IllegalDataException("Family name " + col.getFamilyNameAsString() + " for column " + col.toString() + " not found.");
        }
    }

    public static boolean hasDefaultFamily(List<ColumnSchema> nonPks) {
        for (ColumnSchema col : nonPks) {
            if (col.getFamilyName() == null) {
                return true;
            }
            if (!SchemaUtils.isDefaultFamily(col.getFamilyName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefaultFamilyByMeta(List<LColumn> nonPks) {
        for (LColumn col : nonPks) {
            if (col.getFamilyName() == null) {
                return true;
            }
            if (!SchemaUtils.isDefaultFamily(col.getFamilyName())) continue;
            return true;
        }
        return false;
    }

    public static List<LColumn> convertClientSchemaToInternalSchema(List<PrimaryKeySchema> pkSchema, List<ColumnSchema> nonPkSchema) {
        LColumn column;
        ArrayList<LColumn> ret = CollectionUtils.newArrayListWithCapacity(pkSchema.size() + nonPkSchema.size());
        int position = 0;
        for (PrimaryKeySchema pk : pkSchema) {
            column = new LColumn(pk, position);
            ret.add(column);
            ++position;
        }
        for (ColumnSchema cs : nonPkSchema) {
            column = new LColumn(cs, position);
            ret.add(column);
            ++position;
        }
        return ret;
    }

    public static void convertInternalSchemaToClientSchema(List<LColumn> schema, List<PrimaryKeySchema> pkSchema, List<ColumnSchema> nonPkSchema) {
        pkSchema.clear();
        nonPkSchema.clear();
        for (LColumn c : schema) {
            if (c.isPrimaryKey()) {
                pkSchema.add(SchemaUtils.convertLColumnToPkSchema(c));
                continue;
            }
            nonPkSchema.add(SchemaUtils.convertLColumnToColSchema(c));
        }
    }

    public static PrimaryKeySchema convertLColumnToPkSchema(LColumn c) {
        PrimaryKeySchema primaryKeySchema;
        switch (c.getDataType().getClientType()) {
            case BINARY: {
                primaryKeySchema = new PrimaryKeySchema(c.getColumnName(), c.getDataType().getClientType(), (int)c.getMaxLength(), c.getSortOrder());
                break;
            }
            case DECIMAL: {
                primaryKeySchema = new PrimaryKeySchema(c.getColumnName(), c.getDataType().getClientType(), (int)c.getPrecision(), (int)c.getScale(), c.getSortOrder());
                break;
            }
            default: {
                primaryKeySchema = new PrimaryKeySchema(c.getColumnName(), c.getDataType().getClientType(), c.getSortOrder());
            }
        }
        primaryKeySchema.setHashed(c.isHashed());
        return primaryKeySchema;
    }

    public static ColumnSchema convertLColumnToColSchema(LColumn c) {
        byte[] family = SchemaUtils.isDefaultFamily(c.getFamilyName()) ? null : c.getFamilyName();
        switch (c.getDataType().getClientType()) {
            case BINARY: {
                return new ColumnSchema(family, c.getColumnName(), c.getDataType().getClientType(), (int)c.getMaxLength());
            }
            case DECIMAL: {
                return new ColumnSchema(family, c.getColumnName(), c.getDataType().getClientType(), (int)c.getPrecision(), (int)c.getScale());
            }
        }
        return new ColumnSchema(family, c.getColumnName(), c.getDataType().getClientType());
    }

    public static byte[] columnSchemasToBytes(List<LColumn> columns) throws LindormException {
        try {
            ByteArrayOutputStream schema = new ByteArrayOutputStream();
            DataOutputStream schemaStream = new DataOutputStream(schema);
            WritableUtils.writeVInt(schemaStream, columns.size());
            for (LColumn c : columns) {
                c.writeTo(schemaStream);
            }
            return schema.toByteArray();
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public static List<LColumn> bytesToColumnSchemas(byte[] data) throws LindormException {
        try {
            ByteArrayInputStream schema = new ByteArrayInputStream(data);
            DataInputStream schemaStream = new DataInputStream(schema);
            int count = WritableUtils.readVInt(schemaStream);
            ArrayList<LColumn> columns = CollectionUtils.newArrayListWithCapacity(count);
            for (int i = 0; i < count; ++i) {
                LColumn c = new LColumn();
                c.readFrom(schemaStream);
                columns.add(c);
            }
            return columns;
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public static byte[] columnKeysToBytes(List<ColumnKey> columns) throws LindormException {
        try {
            int length = 0;
            for (ColumnKey ck : columns) {
                length += ck.getByteSize();
            }
            ByteArrayOutputStream schema = new ByteArrayOutputStream(length);
            DataOutputStream schemaStream = new DataOutputStream(schema);
            WritableUtils.writeVInt(schemaStream, columns.size());
            for (ColumnKey c : columns) {
                c.writeTo(schemaStream);
            }
            return schema.toByteArray();
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public static List<ColumnKey> bytesToColumnKeys(byte[] data) throws LindormException {
        try {
            ByteArrayInputStream schema = new ByteArrayInputStream(data);
            DataInputStream schemaStream = new DataInputStream(schema);
            int count = WritableUtils.readVInt(schemaStream);
            ArrayList<ColumnKey> columns = CollectionUtils.newArrayListWithCapacity(count);
            for (int i = 0; i < count; ++i) {
                ColumnKey c = new ColumnKey();
                c.readFrom(schemaStream);
                columns.add(c);
            }
            return columns;
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public static byte[] getFullColumnNameBytes(byte[] familyName, byte[] columnName) {
        if (familyName == null || familyName.length == 0) {
            return columnName;
        }
        return Bytes.add(familyName, COLUMN_NAME_SEPARATOR_BYTES, columnName);
    }

    public static byte[] getFullColumnNameBytes(byte[] familyName, int familyNameOffset, int familyNameLength, byte[] columnName, int columnNameOffset, int columnNameLength) {
        if (familyName == null || familyNameLength == 0) {
            return Arrays.copyOfRange(columnName, columnNameOffset, columnNameLength);
        }
        int length = familyNameLength + columnNameLength + COLUMN_NAME_SEPARATOR_BYTES.length;
        byte[] fullNameBytes = new byte[length];
        int offset = 0;
        offset = Bytes.putBytes(fullNameBytes, offset, familyName, familyNameOffset, familyNameLength);
        offset = Bytes.putBytes(fullNameBytes, offset, COLUMN_NAME_SEPARATOR_BYTES, 0, COLUMN_NAME_SEPARATOR_BYTES.length);
        offset = Bytes.putBytes(fullNameBytes, offset, columnName, columnNameOffset, columnNameLength);
        return fullNameBytes;
    }

    public static String getFullColumnName(byte[] familyName, byte[] columnName) {
        return Bytes.toString(SchemaUtils.getFullColumnNameBytes(familyName, columnName));
    }

    public static String columnSchemaToString(List<LColumn> columns) {
        StringBuilder str = new StringBuilder(256);
        str.append("[");
        for (LColumn col : columns) {
            str.append(col.toString());
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("]");
        return str.toString();
    }

    public static String columnSchemaToString(String tableName, byte[] schemaBytes) {
        try {
            if (schemaBytes != null) {
                StringBuilder ret = new StringBuilder(256);
                ret.append("schema => ");
                List<LColumn> columns = SchemaUtils.bytesToColumnSchemas(schemaBytes);
                ret.append(SchemaUtils.columnSchemaToString(columns));
                return ret.toString();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed printing schema to string for table " + tableName));
        }
        return "";
    }

    public static String tableMetaAttributesToString(Attributes attr) {
        assert (attr != null);
        try {
            Map<String, byte[]> attrMap = attr.getAttributesMap();
            StringBuilder ret = new StringBuilder();
            ret.append("[");
            for (Map.Entry<String, byte[]> entry : attrMap.entrySet()) {
                String value;
                String key = entry.getKey();
                if (key.equals("TABLE_ATTRS")) {
                    TableAttributes ta = new TableAttributes();
                    LindormObjectUtils.getWritable(entry.getValue(), ta);
                    value = ta.toString();
                } else if (key.equals("RANGE_ROUTER")) {
                    RangeRouter rr = new RangeRouter();
                    LindormObjectUtils.getWritable(entry.getValue(), rr);
                    value = "[" + rr.toString() + "]";
                } else if (key.equals("INDEX_NAMES")) {
                    value = Bytes.toString(entry.getValue());
                } else {
                    if (key.equals("INDEX_META")) continue;
                    value = key.equals("INDEX_ID") ? SchemaUtils.indexIdFromBytes(entry.getValue()).toString() : (key.equals("SILENCE_INDEXES") ? SchemaUtils.silenceIndexFromBytes(entry.getValue()).toString() : Bytes.toString(entry.getValue()));
                }
                ret.append(key);
                ret.append(" => ");
                ret.append(value);
                ret.append(",");
            }
            if (attrMap.size() > 0) {
                ret.setLength(ret.length() - 1);
            }
            ret.append("]");
            return ret.toString();
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed print table attributes", t);
            return "[ERROR]";
        }
    }

    public static byte[] indexNamesToBytes(List<String> indexNames) {
        assert (indexNames != null);
        assert (indexNames.size() > 0);
        StringBuilder str = new StringBuilder();
        for (String name : indexNames) {
            str.append(name);
            str.append(",");
        }
        str.setLength(str.length() - 1);
        return Bytes.toBytes(str.toString());
    }

    public static List<String> indexNamesFromBytes(byte[] indexNamesBytes) {
        String indexNamesString = Bytes.toString(indexNamesBytes);
        String[] parsed = indexNamesString.split(",");
        ArrayList<String> indexNames = CollectionUtils.newArrayListWithCapacity(parsed.length);
        Collections.addAll(indexNames, parsed);
        return indexNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] tableMetaMapToBytes(Map<String, TableMeta> metas) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            WritableUtils.writeVInt(out, metas.size());
            for (Map.Entry<String, TableMeta> entry : metas.entrySet()) {
                entry.getValue().writeTo(out);
            }
            out.close();
            byte[] ret = byteStream.toByteArray();
            out = null;
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, TableMeta> tableMetaMapFromBytes(byte[] metaBytes) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(metaBytes, 0, metaBytes.length);
            int size = WritableUtils.readVInt(in);
            ConcurrentHashMap<String, TableMeta> metas = new ConcurrentHashMap<String, TableMeta>(size);
            for (int i = 0; i < size; ++i) {
                TableMeta v = new TableMeta();
                v.readFrom(in);
                metas.put(v.getIndexName(), v);
            }
            ConcurrentHashMap<String, TableMeta> concurrentHashMap = metas;
            return concurrentHashMap;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] indexIdToBytes(Map<Byte, String> ids) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            WritableUtils.writeVInt(out, ids.size());
            for (Map.Entry<Byte, String> entry : ids.entrySet()) {
                WritableUtils.writeVInt(out, entry.getKey().byteValue());
                WritableUtils.writeString(out, entry.getValue());
            }
            out.close();
            byte[] ret = byteStream.toByteArray();
            out = null;
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Byte, String> indexIdFromBytes(byte[] idBytes) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(idBytes, 0, idBytes.length);
            int size = WritableUtils.readVInt(in);
            HashMap<Byte, String> ids = new HashMap<Byte, String>(size);
            for (int i = 0; i < size; ++i) {
                byte id = (byte)WritableUtils.readVInt(in);
                String name = WritableUtils.readString(in);
                ids.put(id, name);
            }
            HashMap<Byte, String> hashMap = ids;
            return hashMap;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] silenceIndexToBytes(Map<String, SilenceIndex> silenceIndexMap) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            WritableUtils.writeVInt(out, silenceIndexMap.size());
            for (Map.Entry<String, SilenceIndex> entry : silenceIndexMap.entrySet()) {
                WritableUtils.writeString(out, entry.getKey());
                entry.getValue().writeTo(out);
            }
            out.close();
            byte[] ret = byteStream.toByteArray();
            out = null;
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, SilenceIndex> silenceIndexFromBytes(byte[] silenceIndexBytes) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(silenceIndexBytes, 0, silenceIndexBytes.length);
            int size = WritableUtils.readVInt(in);
            HashMap<String, SilenceIndex> map = new HashMap<String, SilenceIndex>(size);
            for (int i = 0; i < size; ++i) {
                String key = WritableUtils.readString(in);
                SilenceIndex value = new SilenceIndex();
                value.readFrom(in);
                map.put(key, value);
            }
            HashMap<String, SilenceIndex> hashMap = map;
            return hashMap;
        }
        finally {
            in.close();
        }
    }

    public static String getReadableOperator(ConditionFactory.CompareOp op) {
        switch (op) {
            case LESS: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case GREATER: {
                return ">";
            }
            case IS: {
                return "is";
            }
            case IS_NOT: {
                return "is not";
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator " + (Object)((Object)op));
    }

    public static void setRequireTableMetaToAttributes(Attributes attr) {
        attr.setAttribute(TABLE_META_ATTR_KEY, Bytes.EMPTY_BYTE_ARRAY);
    }

    public static void removeRequireTableMetaToAttributes(Attributes attr) {
        attr.setAttribute(TABLE_META_ATTR_KEY, (byte[])null);
    }

    public static TableMeta getTableMetaFromAttributes(Attributes attr) throws LindormException {
        try {
            byte[] metaBytes = attr.getAttribute(TABLE_META_ATTR_KEY);
            if (metaBytes != null) {
                DataInputStream metaStream = new DataInputStream(new ByteArrayInputStream(metaBytes));
                TableMeta meta = new TableMeta();
                meta.readFrom(metaStream);
                return meta;
            }
            return null;
        }
        catch (Throwable t) {
            throw new LindormException("Failed extracting table meta from attributes", t);
        }
    }

    public static TableMeta getMetaCache(BasicDDLService service, String tableName) throws LindormException {
        return service.getLConnection().getTableMetaCache().getTable(service.getNamespace(), tableName);
    }

    public static TableMeta getMetaCacheForceIfNecessary(BasicDDLService service, String tableName) throws IOException {
        TableMeta meta = service.getLConnection().getTableMetaCache().getTable(service.getNamespace(), tableName);
        if (meta == null) {
            meta = service.getTableMeta(tableName);
            service.getLConnection().getTableMetaCache().addTable(meta);
        }
        return meta;
    }

    public static void registerTableMetaChangedEventHandler(BasicDDLService service, TableMetaChangeEventHandler handler) throws LindormException {
        service.getLConnection().getTableMetaCache().registerMetaChangeHandler(handler);
    }

    public static Pair<byte[], byte[]> getValueBoundary(DataType type) throws LindormException {
        byte[] endKey;
        byte[] startKey;
        switch (type) {
            case BYTE: {
                startKey = LByte.INSTANCE.toBytes((byte)-128);
                endKey = LByte.INSTANCE.toBytes((byte)127);
                break;
            }
            case BOOLEAN: {
                startKey = new byte[]{0};
                endKey = new byte[]{1};
                break;
            }
            case SHORT: {
                startKey = LShort.INSTANCE.toBytes((short)Short.MIN_VALUE);
                endKey = LShort.INSTANCE.toBytes((short)Short.MAX_VALUE);
                break;
            }
            case INT: {
                startKey = LInteger.INSTANCE.toBytes(Integer.MIN_VALUE);
                endKey = LInteger.INSTANCE.toBytes(Integer.MAX_VALUE);
                break;
            }
            case LONG: {
                startKey = LLong.INSTANCE.toBytes(Long.MIN_VALUE);
                endKey = LLong.INSTANCE.toBytes(Long.MAX_VALUE);
                break;
            }
            case FLOAT: {
                startKey = LFloat.INSTANCE.toBytes(Float.valueOf(Float.MIN_VALUE));
                endKey = LFloat.INSTANCE.toBytes(Float.valueOf(Float.MAX_VALUE));
                break;
            }
            case DOUBLE: {
                startKey = LDouble.INSTANCE.toBytes(Double.MIN_VALUE);
                endKey = LDouble.INSTANCE.toBytes(Double.MAX_VALUE);
                break;
            }
            case STRING: {
                startKey = Bytes.toBytes("00");
                endKey = Bytes.toBytes("zz");
                break;
            }
            case VARBINARY: {
                startKey = Bytes.EMPTY_BYTE_ARRAY;
                endKey = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
                break;
            }
            case BINARY: {
                startKey = Bytes.EMPTY_BYTE_ARRAY;
                endKey = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
                break;
            }
            case UNSIGNED_BYTE: {
                startKey = LUnsignedByte.INSTANCE.toBytes(0);
                endKey = LUnsignedByte.INSTANCE.toBytes((byte)127);
                break;
            }
            case UNSIGNED_SHORT: {
                startKey = LUnsignedShort.INSTANCE.toBytes(0);
                endKey = LUnsignedShort.INSTANCE.toBytes((short)Short.MAX_VALUE);
                break;
            }
            case UNSIGNED_INTEGER: {
                startKey = LUnsignedInteger.INSTANCE.toBytes(0);
                endKey = LUnsignedInteger.INSTANCE.toBytes(Integer.MAX_VALUE);
                break;
            }
            case UNSIGNED_LONG: {
                startKey = LUnsignedLong.INSTANCE.toBytes(0);
                endKey = LUnsignedLong.INSTANCE.toBytes(Long.MAX_VALUE);
                break;
            }
            case UNSIGNED_FLOAT: {
                startKey = LUnsignedFloat.INSTANCE.toBytes(0.0);
                endKey = LUnsignedFloat.INSTANCE.toBytes(Float.valueOf(Float.MAX_VALUE));
                break;
            }
            case UNSIGNED_DOUBLE: {
                startKey = LUnsignedDouble.INSTANCE.toBytes(0.0);
                endKey = LUnsignedDouble.INSTANCE.toBytes(Double.MAX_VALUE);
                break;
            }
            case ENCODED_VARBINARY: {
                startKey = Bytes.EMPTY_BYTE_ARRAY;
                endKey = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
                break;
            }
            default: {
                throw new IllegalDataException("Unsupported pk data type : " + (Object)((Object)type));
            }
        }
        return new Pair<byte[], byte[]>(startKey, endKey);
    }

    public static Pair<byte[], byte[]> getValueBoundary(DataType type, Object min, Object max) throws LindormException {
        byte[] endKey;
        byte[] startKey = LDataTypeFactory.INSTANCE.getTypeInstance(type).toBytes(min);
        Preconditions.checkState(Bytes.compareTo(startKey, endKey = LDataTypeFactory.INSTANCE.getTypeInstance(type).toBytes(max)) < 0, "Minimum Range should smaller than Maximum range");
        return new Pair<byte[], byte[]>(startKey, endKey);
    }

    public static byte[][] getSplits(DataType type, int numRegions) throws LindormException {
        Preconditions.checkState(numRegions >= 2, "There must be at least two regions, but has " + numRegions);
        Preconditions.checkState(numRegions <= 4096, "Presplit regions should not exceed 4096, input  " + numRegions);
        Pair<byte[], byte[]> boundary = SchemaUtils.getValueBoundary(type);
        byte[][] splits = Bytes.split(boundary.getFirst(), boundary.getSecond(), true, numRegions - 1);
        Preconditions.checkState(splits != null, "Could not split region with given schema: firstPK type=" + (Object)((Object)type) + ", region number=" + numRegions);
        return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
    }

    public static byte[][] getSplits(DataType type, Object minValue, Object maxValue, int numRegions) throws LindormException {
        Preconditions.checkState(numRegions >= 2, "There must be at least two regions, but has " + numRegions);
        Preconditions.checkState(numRegions <= 4096, "Presplit regions should not exceed 4096, input  " + numRegions);
        Pair<byte[], byte[]> boundary = SchemaUtils.getValueBoundary(type, minValue, maxValue);
        byte[][] splits = Bytes.split(boundary.getFirst(), boundary.getSecond(), true, numRegions - 1);
        Preconditions.checkState(splits != null, "Could not split region with given schema: firstPK type=" + (Object)((Object)type) + ", region number=" + numRegions);
        return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
    }

    public static byte[][] getSplits(byte[] start, byte[] end, int numRegions) {
        Preconditions.checkState(numRegions >= 2, "There must be at least two regions, but has " + numRegions);
        byte[][] splits = Bytes.split(start, end, true, numRegions - 1);
        Preconditions.checkState(splits != null, "Could not split region with given region params: start=" + Bytes.toStringBinary(start) + ", end=" + Bytes.toStringBinary(end) + ", region number=" + numRegions);
        return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
    }

    public static byte[] columnValuesToRowKey(List<ColumnValue> pkValues, List<LColumn> pkSchema) throws LindormException {
        assert (pkValues != null && pkValues.size() > 0);
        assert (pkSchema != null && pkSchema.size() > 0);
        assert (pkValues.size() == pkSchema.size());
        int rowkeySize = 0;
        byte[][] values = new byte[pkValues.size()][];
        for (int i = 0; i < pkValues.size(); ++i) {
            ColumnValue cv = pkValues.get(i);
            LColumn meta = pkSchema.get(i);
            byte[] tmp = LDataType.toBytes(meta, cv);
            values[i] = tmp;
            rowkeySize += tmp.length;
        }
        return CompilerUtils.concatRowKey((byte[][])values, rowkeySize, pkSchema);
    }

    public static List<ColumnValue> rowkeyToColumnValues(byte[] rowkey, TableMeta meta) throws LindormException {
        PrimaryKeyValueAccessor accessor = meta.getPKAccessor();
        PrimaryKeyValueAccessor.ParsedPKValueAccessor parsed = accessor.parseRowKey(rowkey);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        List<LColumn> pkSchema = meta.getPkColumns();
        ArrayList<ColumnValue> ret = CollectionUtils.newArrayListWithCapacity(pkSchema.size());
        for (LColumn pk : pkSchema) {
            parsed.getPKValue(pk.getPosition(), ptr);
            Object value = LDataType.toObject(pk, ptr.get(), ptr.getOffset(), ptr.getLength());
            ColumnValue columnValue = new ColumnValue(null, pk.getColumnName(), value, pk.getDataType().getClientType(), Long.MAX_VALUE);
            ret.add(columnValue);
        }
        return ret;
    }

    public static boolean needOpenRegion(TableMeta tableMeta) {
        if (tableMeta.hasIndex()) {
            return true;
        }
        return SchemaUtils.hasAccColumn(tableMeta.getNonPkColumns());
    }

    public static boolean hasAccColumn(List<LColumn> columnList) {
        List<LColumn> columns = SchemaUtils.getAccLColumnList(columnList);
        return !columns.isEmpty();
    }

    public static List<LColumn> getAccLColumnList(List<LColumn> columnList) {
        ArrayList<LColumn> results = new ArrayList<LColumn>();
        for (LColumn column : columnList) {
            LDataType actualType = column.getDataType();
            if (!SchemaUtils.isAccumulatorType(actualType)) continue;
            results.add(column);
        }
        return results;
    }

    public static boolean isAccumulatorType(LDataType dataType) {
        return DataTypeUtils.equalsAny(dataType, LAccLong.INSTANCE, LAccDouble.INSTANCE);
    }

    public static byte[] conditionToBytes(Condition condition) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        WritableUtils.writeVInt(dataOutputStream, ExpressionType.getOrdinal(condition));
        condition.writeTo(dataOutputStream);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Condition bytesToCondition(byte[] conditionBytes) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(conditionBytes);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        Condition where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(dataInputStream));
        where.readFrom(dataInputStream);
        dataInputStream.close();
        return where;
    }
}

