/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import java.util.Comparator;

public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        public ComparisonChain compare(Comparable left, Comparable right) {
            return this.classify(left.compareTo(right));
        }

        @Override
        public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
            return this.classify(comparator.compare(left, right));
        }

        @Override
        public ComparisonChain compare(int left, int right) {
            return this.classify(ComparisonChain.compareInt(left, right));
        }

        @Override
        public ComparisonChain compare(long left, long right) {
            return this.classify(ComparisonChain.compareLong(left, right));
        }

        @Override
        public ComparisonChain compare(float left, float right) {
            return this.classify(ComparisonChain.compareFloat(left, right));
        }

        @Override
        public ComparisonChain compare(double left, double right) {
            return this.classify(ComparisonChain.compareDouble(left, right));
        }

        @Override
        public ComparisonChain compare(boolean left, boolean right) {
            return this.classify(ComparisonChain.compareBoolean(left, right));
        }

        ComparisonChain classify(int result) {
            return result < 0 ? LESS : (result > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(T var1, T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract ComparisonChain compare(long var1, long var3);

    public abstract ComparisonChain compare(float var1, float var2);

    public abstract ComparisonChain compare(double var1, double var3);

    public abstract ComparisonChain compare(boolean var1, boolean var2);

    public abstract int result();

    private static int compareBoolean(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    private static int compareDouble(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    private static int compareFloat(float f1, float f2) {
        int anotherBits;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(f1);
        return thisBits == (anotherBits = Float.floatToIntBits(f2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    private static int compareLong(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    private static int compareInt(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int result) {
            this.result = result;
        }

        public ComparisonChain compare(Comparable left, Comparable right) {
            return this;
        }

        @Override
        public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(int left, int right) {
            return this;
        }

        @Override
        public ComparisonChain compare(long left, long right) {
            return this;
        }

        @Override
        public ComparisonChain compare(float left, float right) {
            return this;
        }

        @Override
        public ComparisonChain compare(double left, double right) {
            return this;
        }

        @Override
        public ComparisonChain compare(boolean left, boolean right) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

