/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LUnsignedShort
extends LWholeNumberType<Short> {
    public static final LUnsignedShort INSTANCE = new LUnsignedShort();

    private LUnsignedShort() {
        super(DataType.UNSIGNED_SHORT, Short.class);
    }

    @Override
    public int getByteSize() {
        return 2;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return LShort.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeUnsignedShort(((Number)value).shortValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        short v = (Short)LShort.INSTANCE.toObject(value, actualType);
        if (v < 0) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_SHORT type, actual value=" + v);
        }
        return v;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeUnsignedShort(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        return this.toBytes(0);
    }
}

