/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.feedstreamservice.StreamSchema;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.schema.LindormTableAttributeConstants;
import com.alibaba.lindorm.client.schema.Mutability;
import java.util.HashMap;
import java.util.Map;

public class TableAttributes
extends VersionedObjectWithAttributes {
    private Boolean deferredLogFlush = null;
    private Boolean dynamicColumnsEnabled = null;
    private ConsistencyType consistency = null;
    private Mutability mutability = null;
    private Boolean leaderBalanceEnabled = null;
    private Integer glitchTimeout = null;
    private Integer readGlitchTimeout = null;
    private Integer writeGlitchTimeout = null;
    private Boolean usingHashEngine = null;
    private Integer maxPkColumnLength = null;
    private Integer maxNonPkColumnLength = null;
    private StreamSchema streamSchema = null;

    public boolean isDeferredLogFlush() {
        if (this.deferredLogFlush == null) {
            byte[] defer = this.getAttribute("DEFERRED_LOG_FLUSH", LindormTableAttributeConstants.DEFAULT_DEFERRED_LOG_FLUSH_BYTES);
            this.deferredLogFlush = Boolean.valueOf(Bytes.toString(defer));
        }
        return this.deferredLogFlush;
    }

    public void setDeferredLogFlush(boolean defer) {
        this.setAttribute("DEFERRED_LOG_FLUSH", Boolean.toString(defer));
        this.deferredLogFlush = defer;
    }

    public boolean isDynamicColumnsEnabled() {
        if (this.dynamicColumnsEnabled == null) {
            byte[] enabled = this.getAttribute("DYNAMIC_COLUMNS", LindormTableAttributeConstants.DEFAULT_DYNAMIC_COLUMNS_ENABLED_BYTES);
            this.dynamicColumnsEnabled = Boolean.valueOf(Bytes.toString(enabled));
        }
        return this.dynamicColumnsEnabled;
    }

    public void setDynamicColumnsEnabled(boolean enabled) {
        this.setAttribute("DYNAMIC_COLUMNS", Boolean.toString(enabled));
        this.dynamicColumnsEnabled = enabled;
    }

    public ConsistencyType getConsistencyType() {
        if (this.consistency == null) {
            byte[] value = this.getAttribute("CONSISTENCY", LindormTableAttributeConstants.DEFAULT_CONSISTENCY_BYTES);
            this.consistency = ConsistencyType.getConsistencyType(Bytes.toString(value));
        }
        return this.consistency;
    }

    public void setConsistencyType(ConsistencyType type) {
        this.consistency = type;
        this.setAttribute("CONSISTENCY", type.description);
    }

    public int getGlitchTimeout() {
        if (this.glitchTimeout == null) {
            byte[] value = this.getAttribute("GLITCH_TIMEOUT", LindormTableAttributeConstants.DEFAULT_GLITCH_TIMEOUT_BYTES);
            this.glitchTimeout = Integer.valueOf(Bytes.toString(value));
        }
        return this.glitchTimeout;
    }

    public int getReadGlitchTimeout() {
        if (this.readGlitchTimeout == null) {
            byte[] value = this.getAttribute("READ_GLITCH_TIMEOUT", LindormTableAttributeConstants.DEFAULT_GLITCH_TIMEOUT_BYTES);
            this.readGlitchTimeout = Integer.valueOf(Bytes.toString(value));
        }
        return this.readGlitchTimeout;
    }

    public int getWriteGlitchTimeout() {
        if (this.writeGlitchTimeout == null) {
            byte[] value = this.getAttribute("WRITE_GLITCH_TIMEOUT", LindormTableAttributeConstants.DEFAULT_GLITCH_TIMEOUT_BYTES);
            this.writeGlitchTimeout = Integer.valueOf(Bytes.toString(value));
        }
        return this.writeGlitchTimeout;
    }

    public void setGlitchTimeout(int timeout) {
        this.glitchTimeout = timeout;
        this.setAttribute("GLITCH_TIMEOUT", Integer.toString(this.glitchTimeout));
    }

    public void setReadGlitchTimeout(int timeout) {
        this.readGlitchTimeout = timeout;
        this.setAttribute("READ_GLITCH_TIMEOUT", Integer.toString(this.readGlitchTimeout));
    }

    public void setWriteGlitchTimeout(int timeout) {
        this.writeGlitchTimeout = timeout;
        this.setAttribute("WRITE_GLITCH_TIMEOUT", Integer.toString(this.writeGlitchTimeout));
    }

    public Mutability getMutability() {
        if (this.mutability == null) {
            byte[] value = this.getAttribute("MUTABILITY", LindormTableAttributeConstants.DEFAULT_MUTABILITY_BYTES);
            this.mutability = Mutability.valueOf(Bytes.toString(value));
        }
        return this.mutability;
    }

    public Mutability getMutabilityNoDefault() {
        byte[] value = this.getAttribute("MUTABILITY");
        if (value != null) {
            this.mutability = Mutability.valueOf(Bytes.toString(value));
            return this.mutability;
        }
        return null;
    }

    public void setMutability(Mutability m) {
        this.mutability = m;
        this.setAttribute("MUTABILITY", Bytes.toBytes(this.mutability.toString()));
    }

    public boolean isLeaderBalanceEnabled() {
        if (this.leaderBalanceEnabled == null) {
            byte[] value = this.getAttribute("LEADER_BALANCE_ENABLED", LindormTableAttributeConstants.DEFAULT_LEADER_BALANCE_ENABLED_BYTES);
            this.leaderBalanceEnabled = Bytes.toBoolean(value);
        }
        return this.leaderBalanceEnabled;
    }

    public void setLeaderBalance(boolean enable) {
        this.leaderBalanceEnabled = enable;
        this.setAttribute("LEADER_BALANCE_ENABLED", Bytes.toBytes(enable));
    }

    public boolean isHashTable() {
        if (this.usingHashEngine == null) {
            byte[] value = this.getAttribute("USE_HASH_ENGINE", LindormTableAttributeConstants.DEFAULT_USING_HASH_ENGINE_BYTES);
            this.usingHashEngine = Bytes.toBoolean(value);
        }
        return this.usingHashEngine;
    }

    public Boolean isHashTableNoDefault() {
        byte[] value = this.getAttribute("USE_HASH_ENGINE");
        if (value != null) {
            this.usingHashEngine = Bytes.toBoolean(value);
            return this.usingHashEngine;
        }
        return null;
    }

    public void setUsingHashEngine(boolean enableHashEngine) {
        this.usingHashEngine = enableHashEngine;
        this.setAttribute("USE_HASH_ENGINE", Bytes.toBytes(enableHashEngine));
    }

    public Boolean isRefSplitAllowed() {
        byte[] value = this.getAttribute("REF_SPLIT_ALLOWED");
        if (value == null) {
            return null;
        }
        return Bytes.toBoolean(value);
    }

    public void setRefSplitAllowed(boolean enabled) {
        this.setAttribute("REF_SPLIT_ALLOWED", Bytes.toBytes(enabled));
    }

    public int getMaxPkColumnLength() {
        if (this.maxPkColumnLength == null) {
            byte[] value = this.getAttribute("MAX_PK_LEN", LindormTableAttributeConstants.DEFAULT_MAX_PK_COLUMN_LENGTH_BYTES);
            this.maxPkColumnLength = Bytes.toInt(value);
        }
        return this.maxPkColumnLength;
    }

    public Integer getMaxPkColumnLengthNoDefault() {
        byte[] value = this.getAttribute("MAX_PK_LEN");
        if (value != null) {
            this.maxPkColumnLength = Bytes.toInt(value);
            return this.maxPkColumnLength;
        }
        return null;
    }

    public void setMaxPkColumnLength(int maxPkColumnLength) {
        if (maxPkColumnLength <= 0) {
            throw new IllegalArgumentException("Illegal maxPkColumnLength value [" + maxPkColumnLength + "], must be a positive value.");
        }
        this.maxPkColumnLength = maxPkColumnLength;
        this.setAttribute("MAX_PK_LEN", Bytes.toBytes(maxPkColumnLength));
    }

    public int getMaxNonPkColumnLength() {
        if (this.maxNonPkColumnLength == null) {
            byte[] value = this.getAttribute("MAX_NONPK_LEN", LindormTableAttributeConstants.DEFAULT_MAX_NON_PK_COLUMN_LENGTH_BYTES);
            this.maxNonPkColumnLength = Bytes.toInt(value);
        }
        return this.maxNonPkColumnLength;
    }

    public Integer getMaxNonPkColumnLengthNoDefault() {
        byte[] value = this.getAttribute("MAX_NONPK_LEN");
        if (value != null) {
            this.maxNonPkColumnLength = Bytes.toInt(value);
            return this.maxNonPkColumnLength;
        }
        return null;
    }

    public void setMaxNonPkColumnLength(int maxNonPkColumnLength) {
        if (maxNonPkColumnLength <= 0) {
            throw new IllegalArgumentException("Illegal maxNonPkColumnLength value [" + maxNonPkColumnLength + "], must be a positive value.");
        }
        this.maxNonPkColumnLength = maxNonPkColumnLength;
        this.setAttribute("MAX_NONPK_LEN", Bytes.toBytes(maxNonPkColumnLength));
    }

    public boolean isIdempotentEnabled() {
        byte[] value;
        if (this.streamSchema == null && (value = this.getAttribute("SS_STREAM_SCHEMA")) != null) {
            this.streamSchema = new StreamSchema();
            this.streamSchema.fromBytes(value);
        }
        if (this.streamSchema == null) {
            return false;
        }
        return this.streamSchema.hasIdempotentFamily();
    }

    public StreamSchema getStreamSchema() {
        byte[] value;
        if (this.streamSchema == null && (value = this.getAttribute("SS_STREAM_SCHEMA")) != null) {
            this.streamSchema = new StreamSchema();
            this.streamSchema.fromBytes(value);
        }
        return this.streamSchema;
    }

    public void setStreamSchema(StreamSchema schema) {
        this.streamSchema = schema;
        this.setAttribute("SS_STREAM_SCHEMA", this.streamSchema.getBytes());
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static enum ConsistencyType {
        Eventual("eventual"),
        TimeStamp("timestamp"),
        Basic("basic"),
        Strong("strong");

        private final String description;
        private static Map<String, ConsistencyType> stringToConsistencyType;

        private ConsistencyType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static ConsistencyType getConsistencyType(String description) {
            ConsistencyType type = stringToConsistencyType.get(description);
            if (type == null) {
                throw new IllegalArgumentException("No consistency type: " + description + ", Supported: eventual, timestamp, basic, strong");
            }
            return type;
        }

        static {
            stringToConsistencyType = new HashMap<String, ConsistencyType>();
            for (ConsistencyType type : ConsistencyType.values()) {
                stringToConsistencyType.put(type.description, type);
            }
        }
    }
}

